/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.network;

import com.singularity.ee.agent.appagent.boot.transactionmonitor.IBootTransactionContext;
import com.singularity.ee.agent.appagent.boot.transactionmonitor.TransactionMonitorBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BaseMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.kernel.spi.DoNotObfuscate;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethod;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethodDef;
import com.singularity.ee.agent.appagent.services.bciengine.network.ASocketInterceptorTemplate;

public class NIOSocketReadLongInterceptorTemplate
extends ASocketInterceptorTemplate
implements DoNotObfuscate {
    @TemplateMethodDef(type={TemplateMethod.MethodType.methodEntry})
    private static void methodEntryTemplate() {
        try {
            NIOSocketReadLongInterceptorTemplate.setCTC(TransactionMonitorBoot.getInstance().getBootCurrentTransaction());
            if (NIOSocketReadLongInterceptorTemplate.getCTC() != null && NIOSocketReadLongInterceptorTemplate.getCTC().startOfSocketRead() == 1) {
                NIOSocketReadLongInterceptorTemplate.setStartTime(System.currentTimeMillis());
            } else {
                NIOSocketReadLongInterceptorTemplate.setStartTime(0L);
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            NIOSocketReadLongInterceptorTemplate.setCTC(null);
            NIOSocketReadLongInterceptorTemplate.setStartTime(0L);
        }
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.normalMethodExit})
    private static Object methodExitTemplate() {
        try {
            if (NIOSocketReadLongInterceptorTemplate.getCTC() != null) {
                if (NIOSocketReadLongInterceptorTemplate.getStartTime() > 0L) {
                    long timeTaken = System.currentTimeMillis() - NIOSocketReadLongInterceptorTemplate.getStartTime();
                    long bytesRead = NIOSocketReadLongInterceptorTemplate.getreturnValuePrimitive();
                    NIOSocketReadLongInterceptorTemplate.getCTC().socketBytesRead(timeTaken, bytesRead >= 0L ? bytesRead : 0L);
                }
                NIOSocketReadLongInterceptorTemplate.getCTC().endOfSocketRead();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.exceptionMethodExit})
    private static Object exceptionMethodExitTemplate() {
        try {
            if (NIOSocketReadLongInterceptorTemplate.getCTC() != null) {
                NIOSocketReadLongInterceptorTemplate.getCTC().endOfSocketRead();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    protected static void setStartTime(long startTime) {
        ASocketInterceptorTemplate.setStartTime(startTime);
    }

    protected static long getStartTime() {
        return ASocketInterceptorTemplate.getStartTime();
    }

    private static long getreturnValuePrimitive() {
        ASocketInterceptorTemplate.SavedVars sv = (ASocketInterceptorTemplate.SavedVars)refToCurrentTopOfStack.get();
        if (sv != null) {
            return sv.getReturnValue();
        }
        return 0L;
    }

    protected static IBootTransactionContext getCTC() {
        return ASocketInterceptorTemplate.getCTC();
    }

    protected static void setCTC(IBootTransactionContext ctc) {
        ASocketInterceptorTemplate.setCTC(ctc);
    }

    @Override
    protected void methodExitTemplateNonInline() {
        NIOSocketReadLongInterceptorTemplate.methodExitTemplate();
    }

    @Override
    protected void methodEntryTemplateNonInline() {
        NIOSocketReadLongInterceptorTemplate.methodEntryTemplate();
    }

    @Override
    protected void methodExitExceptionTemplateNonInline() {
        NIOSocketReadLongInterceptorTemplate.exceptionMethodExitTemplate();
    }
}

