/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.network;

import com.singularity.ee.agent.appagent.boot.transactionmonitor.IBootTransactionContext;
import com.singularity.ee.agent.appagent.boot.transactionmonitor.TransactionMonitorBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BaseMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.kernel.spi.DoNotObfuscate;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethod;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethodDef;
import com.singularity.ee.agent.appagent.services.bciengine.network.ASocketInterceptorTemplate;

public class NIOSocketWriteIntInterceptorTemplate
extends ASocketInterceptorTemplate
implements DoNotObfuscate {
    @TemplateMethodDef(type={TemplateMethod.MethodType.methodEntry})
    private static void methodEntryTemplate() {
        try {
            NIOSocketWriteIntInterceptorTemplate.setCTC(TransactionMonitorBoot.getInstance().getBootCurrentTransaction());
            if (NIOSocketWriteIntInterceptorTemplate.getCTC() != null && NIOSocketWriteIntInterceptorTemplate.getCTC().startOfSocketWrite() == 1) {
                NIOSocketWriteIntInterceptorTemplate.setStartTime(System.currentTimeMillis());
            } else {
                NIOSocketWriteIntInterceptorTemplate.setStartTime(0L);
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            NIOSocketWriteIntInterceptorTemplate.setCTC(null);
            NIOSocketWriteIntInterceptorTemplate.setStartTime(0L);
        }
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.normalMethodExit})
    private static Object methodExitTemplate() {
        try {
            if (NIOSocketWriteIntInterceptorTemplate.getCTC() != null) {
                if (NIOSocketWriteIntInterceptorTemplate.getStartTime() > 0L) {
                    long timeTaken = System.currentTimeMillis() - NIOSocketWriteIntInterceptorTemplate.getStartTime();
                    int bytesWritten = NIOSocketWriteIntInterceptorTemplate.getreturnValuePrimitive();
                    NIOSocketWriteIntInterceptorTemplate.getCTC().socketBytesWritten(timeTaken, (long)bytesWritten);
                }
                NIOSocketWriteIntInterceptorTemplate.getCTC().endOfSocketWrite();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.exceptionMethodExit})
    private static Object exceptionMethodExitTemplate() {
        try {
            if (NIOSocketWriteIntInterceptorTemplate.getCTC() != null) {
                NIOSocketWriteIntInterceptorTemplate.getCTC().endOfSocketWrite();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    protected static void setStartTime(long startTime) {
        ASocketInterceptorTemplate.setStartTime(startTime);
    }

    protected static long getStartTime() {
        return ASocketInterceptorTemplate.getStartTime();
    }

    private static int getreturnValuePrimitive() {
        ASocketInterceptorTemplate.SavedVars sv = (ASocketInterceptorTemplate.SavedVars)refToCurrentTopOfStack.get();
        if (sv != null) {
            return (int)sv.getReturnValue();
        }
        return 0;
    }

    protected static IBootTransactionContext getCTC() {
        return ASocketInterceptorTemplate.getCTC();
    }

    protected static void setCTC(IBootTransactionContext ctc) {
        ASocketInterceptorTemplate.setCTC(ctc);
    }

    @Override
    protected void methodExitTemplateNonInline() {
        NIOSocketWriteIntInterceptorTemplate.methodExitTemplate();
    }

    @Override
    protected void methodEntryTemplateNonInline() {
        NIOSocketWriteIntInterceptorTemplate.methodEntryTemplate();
    }

    @Override
    protected void methodExitExceptionTemplateNonInline() {
        NIOSocketWriteIntInterceptorTemplate.exceptionMethodExitTemplate();
    }
}

