/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.network;

import com.singularity.ee.agent.appagent.boot.transactionmonitor.IBootTransactionContext;
import com.singularity.ee.agent.appagent.boot.transactionmonitor.TransactionMonitorBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BaseMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.kernel.spi.DoNotObfuscate;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethod;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethodDef;
import com.singularity.ee.agent.appagent.services.bciengine.network.ASocketInterceptorTemplate;

public class NIOSocketWriteLongInterceptorTemplate
extends ASocketInterceptorTemplate
implements DoNotObfuscate {
    @TemplateMethodDef(type={TemplateMethod.MethodType.methodEntry})
    private static void methodEntryTemplate() {
        try {
            NIOSocketWriteLongInterceptorTemplate.setCTC(TransactionMonitorBoot.getInstance().getBootCurrentTransaction());
            if (NIOSocketWriteLongInterceptorTemplate.getCTC() != null && NIOSocketWriteLongInterceptorTemplate.getCTC().startOfSocketWrite() == 1) {
                NIOSocketWriteLongInterceptorTemplate.setStartTime(System.currentTimeMillis());
            } else {
                NIOSocketWriteLongInterceptorTemplate.setStartTime(0L);
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            NIOSocketWriteLongInterceptorTemplate.setCTC(null);
            NIOSocketWriteLongInterceptorTemplate.setStartTime(0L);
        }
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.normalMethodExit})
    private static Object methodExitTemplate() {
        try {
            if (NIOSocketWriteLongInterceptorTemplate.getCTC() != null) {
                if (NIOSocketWriteLongInterceptorTemplate.getStartTime() > 0L) {
                    long timeTaken = System.currentTimeMillis() - NIOSocketWriteLongInterceptorTemplate.getStartTime();
                    long bytesWritten = NIOSocketWriteLongInterceptorTemplate.getreturnValuePrimitive();
                    NIOSocketWriteLongInterceptorTemplate.getCTC().socketBytesWritten(timeTaken, bytesWritten);
                }
                NIOSocketWriteLongInterceptorTemplate.getCTC().endOfSocketWrite();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.exceptionMethodExit})
    private static Object exceptionMethodExitTemplate() {
        try {
            if (NIOSocketWriteLongInterceptorTemplate.getCTC() != null) {
                NIOSocketWriteLongInterceptorTemplate.getCTC().endOfSocketWrite();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    protected static void setStartTime(long startTime) {
        ASocketInterceptorTemplate.setStartTime(startTime);
    }

    protected static long getStartTime() {
        return ASocketInterceptorTemplate.getStartTime();
    }

    private static long getreturnValuePrimitive() {
        ASocketInterceptorTemplate.SavedVars sv = (ASocketInterceptorTemplate.SavedVars)refToCurrentTopOfStack.get();
        if (sv != null) {
            return sv.getReturnValue();
        }
        return 0L;
    }

    protected static IBootTransactionContext getCTC() {
        return ASocketInterceptorTemplate.getCTC();
    }

    protected static void setCTC(IBootTransactionContext ctc) {
        ASocketInterceptorTemplate.setCTC(ctc);
    }

    @Override
    protected void methodExitTemplateNonInline() {
        NIOSocketWriteLongInterceptorTemplate.methodExitTemplate();
    }

    @Override
    protected void methodEntryTemplateNonInline() {
        NIOSocketWriteLongInterceptorTemplate.methodEntryTemplate();
    }

    @Override
    protected void methodExitExceptionTemplateNonInline() {
        NIOSocketWriteLongInterceptorTemplate.exceptionMethodExitTemplate();
    }
}

