/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.network;

import com.singularity.ee.agent.appagent.boot.transactionmonitor.IBootTransactionContext;
import com.singularity.ee.agent.appagent.boot.transactionmonitor.TransactionMonitorBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BaseMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.kernel.spi.DoNotObfuscate;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethod;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethodDef;
import com.singularity.ee.agent.appagent.services.bciengine.network.ASocketInterceptorTemplate;

public class SocketInputStreamReadInterceptorTemplate
extends ASocketInterceptorTemplate
implements DoNotObfuscate {
    @TemplateMethodDef(type={TemplateMethod.MethodType.methodEntry})
    private static void methodEntryTemplate() {
        try {
            SocketInputStreamReadInterceptorTemplate.setCTC(TransactionMonitorBoot.getInstance().getBootCurrentTransaction());
            if (SocketInputStreamReadInterceptorTemplate.getCTC() != null && SocketInputStreamReadInterceptorTemplate.getCTC().startOfSocketRead() == 1) {
                SocketInputStreamReadInterceptorTemplate.setStartTime(System.currentTimeMillis());
            } else {
                SocketInputStreamReadInterceptorTemplate.setStartTime(0L);
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            SocketInputStreamReadInterceptorTemplate.setCTC(null);
            SocketInputStreamReadInterceptorTemplate.setStartTime(0L);
        }
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.normalMethodExit})
    private static Object methodExitTemplate() {
        try {
            if (SocketInputStreamReadInterceptorTemplate.getCTC() != null) {
                if (SocketInputStreamReadInterceptorTemplate.getStartTime() > 0L) {
                    long timeTaken = System.currentTimeMillis() - SocketInputStreamReadInterceptorTemplate.getStartTime();
                    int bytesRead = SocketInputStreamReadInterceptorTemplate.getreturnValuePrimitive();
                    SocketInputStreamReadInterceptorTemplate.getCTC().socketBytesRead(timeTaken, (long)bytesRead >= 0L ? (long)bytesRead : 0L);
                }
                SocketInputStreamReadInterceptorTemplate.getCTC().endOfSocketRead();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    @TemplateMethodDef(type={TemplateMethod.MethodType.exceptionMethodExit})
    private static Object exceptionMethodExitTemplate() {
        try {
            if (SocketInputStreamReadInterceptorTemplate.getCTC() != null) {
                SocketInputStreamReadInterceptorTemplate.getCTC().endOfSocketRead();
            }
        }
        catch (Throwable t) {
            BaseMethodInterceptorDelegatorBoot.safeError((Throwable)t);
            return null;
        }
        return null;
    }

    protected static void setStartTime(long startTime) {
        ASocketInterceptorTemplate.setStartTime(startTime);
    }

    protected static long getStartTime() {
        return ASocketInterceptorTemplate.getStartTime();
    }

    private static int getreturnValuePrimitive() {
        ASocketInterceptorTemplate.SavedVars sv = (ASocketInterceptorTemplate.SavedVars)refToCurrentTopOfStack.get();
        if (sv != null) {
            return (int)sv.getReturnValue();
        }
        return 0;
    }

    protected static IBootTransactionContext getCTC() {
        return ASocketInterceptorTemplate.getCTC();
    }

    protected static void setCTC(IBootTransactionContext ctc) {
        ASocketInterceptorTemplate.setCTC(ctc);
    }

    @Override
    protected void methodExitTemplateNonInline() {
        SocketInputStreamReadInterceptorTemplate.methodExitTemplate();
    }

    @Override
    protected void methodEntryTemplateNonInline() {
        SocketInputStreamReadInterceptorTemplate.methodEntryTemplate();
    }

    @Override
    protected void methodExitExceptionTemplateNonInline() {
        SocketInputStreamReadInterceptorTemplate.exceptionMethodExitTemplate();
    }
}

