/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.spi.filters;

import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaDataUtility;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.IRuntimeClassInfoHelper;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;

public class RuntimeClassInfoMetaDataHelper
implements IRuntimeClassInfoHelper {
    private final IClassMetaData classMetaData;
    private final IClassMetaDataManager metaDataManager;

    public RuntimeClassInfoMetaDataHelper(IClassMetaData classMetaData, IClassMetaDataManager metaDataManager) {
        this.classMetaData = classMetaData;
        this.metaDataManager = metaDataManager;
    }

    @Override
    public boolean isAssignableFrom(String className) {
        String name = ClassNameUtils.convertClassNameToExternalFormat(className);
        IClassMetaData subClassOrInterface = this.metaDataManager.getClassMetaData(name, this.classMetaData.getClassLoader());
        if (subClassOrInterface == null) {
            return false;
        }
        return this.classMetaData.isAssignableFrom(subClassOrInterface);
    }

    @Override
    public boolean isAssignableTo(String className) {
        String name = ClassNameUtils.convertClassNameToExternalFormat(className);
        IClassMetaData subClassOrInterface = this.metaDataManager.getClassMetaData(name, this.classMetaData.getClassLoader(), false);
        if (subClassOrInterface == null) {
            return false;
        }
        return subClassOrInterface.isAssignableFrom(this.classMetaData);
    }

    @Override
    public boolean hasDirectAnnotation(StringMatchBoot annotationName) {
        return ClassMetaDataUtility.hasAnnotation(this.classMetaData, annotationName);
    }

    @Override
    public boolean hasAnnotation(StringMatchBoot annotationName) {
        return ClassMetaDataUtility.hasAnnotation(this.classMetaData, annotationName);
    }

    @Override
    public boolean extendsFromClass(StringMatchBoot superClassFilter) {
        return ClassMetaDataUtility.extendsFromClass(this.classMetaData, superClassFilter);
    }

    @Override
    public boolean implementsInterface(StringMatchBoot interfaceName) {
        return ClassMetaDataUtility.implementsInterface(this.classMetaData, interfaceName);
    }

    @Override
    public boolean implementsInterface(String interfaceName) {
        return ClassMetaDataUtility.implementsInterface(this.classMetaData, interfaceName);
    }

    @Override
    public boolean matchString(StringMatchBoot className) {
        return className.matchString(this.classMetaData.getName());
    }

    @Override
    public String getClassName() {
        return this.classMetaData.getName();
    }

    @Override
    public boolean equalsOrIsAssignableFrom(String name) {
        return ClassMetaDataUtility.equalsOrIsAssignableFrom(this.classMetaData, name);
    }

    @Override
    public String[] getAllInterfaceNames(String[] initialInterfaceNames) {
        return this.classMetaData.getAllInterfaceNames();
    }

    @Override
    public boolean isNonClassType() {
        return this.classMetaData.isAnnotation() || this.classMetaData.isEnum() || this.classMetaData.isInterface();
    }
}

