/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.attributes;

import com.singularity.ee.agent.appagent.services.bciengine.ASMConsumerFactory;
import com.singularity.ee.agent.appagent.services.bciengine.BCILock;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.IClassAttributeExtractor;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.IClassAttributeFilter;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class ClassAttributeManager {
    private static ClassAttributeManager instance;
    private final LockedMap<ClassLoader, HashMap<String, Set<ClassAttribute>>> classLoaderVsClassMap;
    private final ClassLoader bootPlaceHolder = new DummyClassLoader();

    public static ClassAttributeManager getInstance() {
        if (instance == null) {
            ClassAttributeManager.getInstanceSync();
        }
        return instance;
    }

    private static synchronized ClassAttributeManager getInstanceSync() {
        if (instance == null) {
            instance = new ClassAttributeManager();
        }
        return instance;
    }

    private ClassAttributeManager() {
        this.classLoaderVsClassMap = new LockedMap();
    }

    public void extractAndSaveAttributes(String className, ClassLoader classLoader, byte[] classBytes) throws TimeoutWaitingForLockException {
        this.extractAndSaveAttributes(className, classLoader, classBytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractAndSaveAttributes(String className, ClassLoader classLoader, byte[] classBytes, IClassAttributeFilter filter) throws TimeoutWaitingForLockException {
        Set<ClassAttribute> extractedAttributes = ClassAttributeManager.getClassAttributes(className, classBytes, filter);
        if (extractedAttributes.size() > 0) {
            ClassLoader tempClassLoader = classLoader != null ? classLoader : this.bootPlaceHolder;
            this.classLoaderVsClassMap.synchronize();
            try {
                Set<ClassAttribute> existingAttributes;
                HashMap<String, Set<ClassAttribute>> classNameVsAttributes = (HashMap<String, Set<ClassAttribute>>)this.classLoaderVsClassMap.get(tempClassLoader);
                if (classNameVsAttributes == null) {
                    classNameVsAttributes = new HashMap<String, Set<ClassAttribute>>();
                    this.classLoaderVsClassMap.put(tempClassLoader, classNameVsAttributes);
                }
                if ((existingAttributes = (Set<ClassAttribute>)classNameVsAttributes.get(className)) == null) {
                    existingAttributes = extractedAttributes;
                    classNameVsAttributes.put(className, existingAttributes);
                }
                if (existingAttributes != extractedAttributes) {
                    existingAttributes.addAll(extractedAttributes);
                }
            }
            finally {
                this.classLoaderVsClassMap.unsynchronize();
            }
        }
    }

    private static Set<ClassAttribute> getClassAttributes(String className, byte[] classBytes, IClassAttributeFilter filter) {
        IClassAttributeExtractor extractor = ASMConsumerFactory.createAttributeExtractor(className);
        extractor.extractAttributes(classBytes);
        Set<ClassAttribute> extractedAttributes = extractor.getAllDiscoveredAttributes();
        if (filter != null) {
            Iterator<ClassAttribute> iter = extractedAttributes.iterator();
            while (iter.hasNext()) {
                ClassAttribute nextAttr = iter.next();
                if (filter.shouldAttributeBeKept(nextAttr)) continue;
                iter.remove();
            }
        }
        return extractedAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClassAttribute> getClassAttributes(String className, ClassLoader classLoader) throws TimeoutWaitingForLockException {
        HashSet<ClassAttribute> returnSet = null;
        ClassLoader tempClassLoader = classLoader != null ? classLoader : this.bootPlaceHolder;
        this.classLoaderVsClassMap.synchronize();
        try {
            HashMap classNameVsAttributes = (HashMap)this.classLoaderVsClassMap.get(tempClassLoader);
            if (classNameVsAttributes == null) {
                HashSet<ClassAttribute> hashSet = returnSet;
                return hashSet;
            }
            Set existingSet = (Set)classNameVsAttributes.get(className);
            if (existingSet != null) {
                returnSet = new HashSet<ClassAttribute>(existingSet);
            }
        }
        finally {
            this.classLoaderVsClassMap.unsynchronize();
        }
        return returnSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ClassAttribute> verifyAllClassAttributesExist(String className, ClassLoader classLoader, byte[] classBytes, IClassAttributeFilter filter) throws TimeoutWaitingForLockException {
        Set existingSet;
        ArrayList<ClassAttribute> missingAttributes = new ArrayList<ClassAttribute>();
        ClassLoader tempClassLoader = classLoader != null ? classLoader : this.bootPlaceHolder;
        this.classLoaderVsClassMap.synchronize();
        try {
            HashMap classNameVsAttributes = (HashMap)this.classLoaderVsClassMap.get(tempClassLoader);
            if (classNameVsAttributes == null) {
                ArrayList<ClassAttribute> arrayList = missingAttributes;
                return arrayList;
            }
            existingSet = (Set)classNameVsAttributes.get(className);
        }
        finally {
            this.classLoaderVsClassMap.unsynchronize();
        }
        if (existingSet != null) {
            Set<ClassAttribute> newAttributes = ClassAttributeManager.getClassAttributes(className, classBytes, null);
            for (ClassAttribute nextAttr : existingSet) {
                if (filter != null && filter.shouldAttributeBeKept(nextAttr) || newAttributes.contains(nextAttr)) continue;
                BCTLoggerUtil.warn("Warning - original class attribute " + nextAttr.toString() + " missing from latest version of class " + className);
                missingAttributes.add(nextAttr);
            }
        }
        return missingAttributes;
    }

    public LockedMap<ClassLoader, HashMap<String, Set<ClassAttribute>>> getClassLoaderMap() {
        return this.classLoaderVsClassMap;
    }

    public ClassLoader getBootPlaceHolder() {
        return this.bootPlaceHolder;
    }

    private class DummyClassLoader
    extends ClassLoader {
        private DummyClassLoader() {
        }
    }

    public class LockedMap<K, V>
    extends WeakHashMap<K, V> {
        private final BCILock lock = new BCILock("ClassAttributeManager.LockedMap");

        LockedMap() {
        }

        void synchronize() throws TimeoutWaitingForLockException {
            this.lock.synchronize();
        }

        void unsynchronize() {
            this.lock.unsynchronize();
        }
    }
}

