/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.attributes;

import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttribute;
import com.singularity.ee.util.string.StringOperations;

public class EnclosingMethodAttribute
extends ClassAttribute {
    private final String enclosingClass;
    private final String enclosingMethodName;
    private final String enclosingMethodDesc;
    private final int hashValue;

    public EnclosingMethodAttribute(String enclosingClass, String enclosingMethodName, String enclosingMethodDesc) {
        this.enclosingClass = enclosingClass;
        this.enclosingMethodName = enclosingMethodName;
        this.enclosingMethodDesc = enclosingMethodDesc;
        this.hashValue = ClassAttribute.AttributeType.EnclosingMethod.ordinal() ^ (enclosingClass != null ? enclosingClass.hashCode() : 0) ^ (enclosingMethodName != null ? enclosingMethodName.hashCode() : 0) ^ (enclosingMethodDesc != null ? enclosingMethodDesc.hashCode() : 0);
    }

    @Override
    public ClassAttribute.AttributeType getAttributeType() {
        return ClassAttribute.AttributeType.EnclosingMethod;
    }

    public String getEnclosingClass() {
        return this.enclosingClass;
    }

    public String getEnclosingMethodName() {
        return this.enclosingMethodName;
    }

    public String getEnclosingMethodDesc() {
        return this.enclosingMethodDesc;
    }

    @Override
    public int hashCode() {
        return this.hashValue;
    }

    @Override
    public boolean equals(Object o) {
        boolean bReturn;
        boolean bl = bReturn = this == o;
        if (!bReturn && o.getClass() == this.getClass()) {
            EnclosingMethodAttribute other = (EnclosingMethodAttribute)o;
            bReturn = this.hashValue == other.hashValue && StringOperations.eqOrNull((String)this.enclosingClass, (String)other.enclosingClass) && StringOperations.eqOrNull((String)this.enclosingMethodName, (String)other.enclosingMethodName) && StringOperations.eqOrNull((String)this.enclosingMethodDesc, (String)other.enclosingMethodDesc);
        }
        return bReturn;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EnclosingMethod attribute.");
        if (this.enclosingClass != null) {
            sb.append("  enclosingClass = ").append(this.enclosingClass).append(".");
        }
        if (this.enclosingMethodName != null) {
            sb.append("  enclosingMethodName = ").append(this.enclosingMethodName).append(".");
        }
        if (this.enclosingMethodDesc != null) {
            sb.append("  enclosingMethodDesc = ").append(this.enclosingMethodDesc).append(".");
        }
        return sb.toString();
    }
}

