/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.attributes;

import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttribute;
import com.singularity.ee.util.string.StringOperations;

public class InnerClassAttribute
extends ClassAttribute {
    private final String name;
    private final String outerName;
    private final String innerName;
    private final int access;
    private int hashValue;

    public InnerClassAttribute(String name, String outerName, String innerName, int access) {
        this.name = name;
        this.outerName = outerName;
        this.innerName = innerName;
        this.access = access;
        this.hashValue = ClassAttribute.AttributeType.InnerClasses.ordinal() ^ name.hashCode();
        if (outerName != null) {
            this.hashValue ^= outerName.hashCode();
        }
        if (innerName != null) {
            this.hashValue ^= innerName.hashCode();
        }
    }

    @Override
    public ClassAttribute.AttributeType getAttributeType() {
        return ClassAttribute.AttributeType.InnerClasses;
    }

    @Override
    public int hashCode() {
        return this.hashValue;
    }

    @Override
    public boolean equals(Object o) {
        boolean bReturn;
        boolean bl = bReturn = this == o;
        if (!bReturn && this.getClass() == o.getClass()) {
            InnerClassAttribute other = (InnerClassAttribute)o;
            bReturn = this.hashValue == other.hashValue && StringOperations.eqOrNull((String)this.name, (String)other.name) && StringOperations.eqOrNull((String)this.outerName, (String)other.outerName) && StringOperations.eqOrNull((String)this.innerName, (String)other.innerName);
        }
        return bReturn;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InnerClass attribute.");
        if (this.name != null) {
            sb.append("  name = ").append(this.name).append(".");
        }
        if (this.outerName != null) {
            sb.append("  outerName = ").append(this.outerName).append(".");
        }
        if (this.innerName != null) {
            sb.append("  innerName = ").append(this.innerName).append(".");
        }
        return sb.toString();
    }
}

