/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.attributes;

import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttribute;
import com.singularity.ee.util.string.StringOperations;

public class SourceAttribute
extends ClassAttribute {
    private final String source;
    private final String debug;
    private int hashValue;

    public SourceAttribute(String source, String debug) {
        this.source = source;
        this.debug = debug;
        this.hashValue = ClassAttribute.AttributeType.SourceFile.ordinal();
        if (source != null) {
            this.hashValue ^= source.hashCode();
        }
        if (debug != null) {
            this.hashValue ^= debug.hashCode();
        }
    }

    @Override
    public ClassAttribute.AttributeType getAttributeType() {
        return ClassAttribute.AttributeType.SourceFile;
    }

    @Override
    public int hashCode() {
        return this.hashValue;
    }

    @Override
    public boolean equals(Object o) {
        boolean bReturn;
        boolean bl = bReturn = this == o;
        if (!bReturn && this.getClass() == o.getClass()) {
            SourceAttribute other = (SourceAttribute)o;
            bReturn = this.hashValue == other.hashValue && StringOperations.eqOrNull((String)this.source, (String)other.source) && StringOperations.eqOrNull((String)this.debug, (String)other.debug);
        }
        return bReturn;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SourceFile attribute.");
        if (this.source != null) {
            sb.append("  source = ").append(this.source).append(".");
        }
        if (this.debug != null) {
            sb.append("  debug = ").append(this.debug).append(".");
        }
        return sb.toString();
    }
}

