/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.custom.instrumentation;

import com.singularity.ee.agent.appagent.services.bciengine.IOpcodeToString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Instruction {
    private static final int MAX_CACHE_SIZE = 4;
    public static final int NOOPCODE = Integer.MIN_VALUE;
    private String method;
    private int opcode = Integer.MIN_VALUE;
    private Object[] vars = null;
    private static ThreadLocal<List<Instruction>> localCache = new ThreadLocal<List<Instruction>>(){

        @Override
        protected List<Instruction> initialValue() {
            return new ArrayList<Instruction>(4);
        }
    };

    private Instruction() {
    }

    public String toString() {
        return "[" + this.getMethod() + "] [" + IOpcodeToString.INSTANCE.resolveOpcode(this.getOpcode()) + "] " + Arrays.asList(this.getVars()).toString();
    }

    public String getMethod() {
        return this.method;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Object[] getVars() {
        return this.vars;
    }

    public void reset(String method, int opcode, Object ... vars) {
        this.method = method;
        this.opcode = opcode;
        this.vars = vars;
    }

    public static Instruction newInstruction(String method, int opcode, Object ... vars) {
        List<Instruction> cache = localCache.get();
        Instruction instruction = !cache.isEmpty() ? cache.remove(cache.size() - 1) : new Instruction();
        instruction.reset(method, opcode, vars);
        return instruction;
    }

    public static void release(List<Instruction> instructions) {
        List<Instruction> cache = localCache.get();
        int canTake = 4 - cache.size();
        for (int i = 0; canTake > 0 && i < instructions.size(); --canTake, ++i) {
            Instruction instruction = instructions.get(i);
            instruction.reset(null, 0, new Object[0]);
            cache.add(instruction);
        }
        instructions.clear();
    }
}

