/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.custom.interceptors;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ATransformationRuleContext;
import com.singularity.ee.util.collections.EqualsUtil;
import com.singularity.ee.util.collections.HashCodeUtil;
import com.singularity.ee.util.dtobootimpl.POJOMatchTypeBoot;
import com.singularity.ee.util.dtobootimpl.POJOMethodDefinitionBoot;
import java.util.Arrays;
import java.util.List;

public class BCIMatchRule {
    private final POJOMatchTypeBoot matchClassType;
    private final String className;
    private final String methodName;
    private List<String> methodParams;
    private boolean matchNoArgsOnly;
    private String returnType;
    private String interceptorClassName;
    private Class interceptorClass;
    private ATransformationRuleContext ruleContext;
    private String moduleName;

    public BCIMatchRule(POJOMatchTypeBoot matchClassType, String className, String methodName, List<String> methodParams, boolean matchNoArgsOnly, String returnType, String interceptorClassName) {
        this.matchClassType = matchClassType;
        this.className = className;
        this.methodName = methodName;
        this.methodParams = methodParams;
        this.matchNoArgsOnly = matchNoArgsOnly;
        this.returnType = returnType;
        this.interceptorClassName = interceptorClassName;
    }

    public BCIMatchRule(POJOMatchTypeBoot matchClassType, String className, String methodName, String[] methodParams, String interceptorClassName) {
        this(matchClassType, className, methodName, Arrays.asList(methodParams), false, "void", interceptorClassName);
    }

    public BCIMatchRule(POJOMatchTypeBoot matchClassType, String className, String methodName, List<String> methodParams, boolean matchNoArgsOnly, String interceptorClassName) {
        this(matchClassType, className, methodName, methodParams, matchNoArgsOnly, "void", interceptorClassName);
    }

    public BCIMatchRule(POJOMatchTypeBoot matchClassType, String className, String methodName, String[] methodParams, Class<? extends AMethodInterceptor> interceptorClass) {
        this(matchClassType, className, methodName, Arrays.asList(methodParams), interceptorClass);
    }

    public BCIMatchRule(POJOMatchTypeBoot matchClassType, String className, String methodName, List<String> methodParams, Class<? extends AMethodInterceptor> interceptorClass) {
        this.matchClassType = matchClassType;
        this.className = className;
        this.methodName = methodName;
        this.methodParams = methodParams;
        this.interceptorClass = interceptorClass;
    }

    public BCIMatchRule(POJOMatchTypeBoot matchClassType, String classMatch, String methodMatch, Class<? extends AMethodInterceptor> interceptorClass) {
        this.matchClassType = matchClassType;
        this.className = classMatch;
        this.methodName = methodMatch;
        this.interceptorClass = interceptorClass;
    }

    public POJOMatchTypeBoot getMatchClassType() {
        return this.matchClassType;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getMethodParams() {
        return this.methodParams;
    }

    public boolean isMatchNoArgsOnly() {
        return this.matchNoArgsOnly;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getInterceptorClassName() {
        return this.interceptorClassName;
    }

    public Class getInterceptorClass() {
        return this.interceptorClass;
    }

    public ATransformationRuleContext getRuleContext() {
        return this.ruleContext;
    }

    public void setRuleContext(ATransformationRuleContext ruleContext) {
        this.ruleContext = ruleContext;
    }

    public static BCIMatchRule fromPOJOMethodDefinition(POJOMethodDefinitionBoot methodDef, String interceptorClassName) {
        BCIMatchRule returnMatchRule = new BCIMatchRule(methodDef.getMatchType(), methodDef.getClassName(), methodDef.getMethodName(), methodDef.getMethodParameterTypes() != null ? Arrays.asList(methodDef.getMethodParameterTypes()) : null, methodDef.isMatchNoArgsOnly(), interceptorClassName);
        String moduleName = methodDef.getModuleName();
        if (moduleName != null) {
            returnMatchRule.setModuleName(moduleName);
        }
        return returnMatchRule;
    }

    public int hashCode() {
        return HashCodeUtil.calculateHashCode(new Object[]{this.matchClassType, this.className, this.methodName, this.methodParams, this.returnType, this.moduleName});
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BCIMatchRule)) {
            return false;
        }
        BCIMatchRule other = (BCIMatchRule)o;
        return other.matchClassType == this.matchClassType && other.className.equals(this.className) && EqualsUtil.safeCompareStrings(other.methodName, this.methodName) && EqualsUtil.safeCompareCollections(this.methodParams, other.methodParams) && EqualsUtil.safeCompareStrings(this.returnType, other.returnType) && EqualsUtil.safeCompareStrings(this.moduleName, other.moduleName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("POJO Match Rule :").append((Object)this.matchClassType);
        sb.append("\tClass Match Data :").append(this.className);
        sb.append("\tMethod Name:").append(this.methodName);
        sb.append("\tMethod Params:").append(this.methodParams);
        sb.append("\tMatch No Args Only:").append(String.valueOf(this.matchNoArgsOnly));
        sb.append("\tReturn Param:").append(this.returnType);
        if (this.moduleName != null) {
            sb.append("\tModule Name Filter:").append(this.moduleName);
        }
        if (this.interceptorClassName != null) {
            sb.append("\tInterceptor Class Name:").append(this.interceptorClassName);
        } else if (this.interceptorClass != null) {
            sb.append("\tInterceptor Class:").append(this.interceptorClass.getName());
        }
        return sb.toString();
    }
}

