/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.custom.interceptors.config;

import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.InterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleHelper;
import com.singularity.ee.agent.appagent.services.bciengine.custom.interceptors.config.CustomRuleConfigurationContext;
import com.singularity.ee.agent.appagent.services.bciengine.custom.interceptors.config.CustomRuleTagNames;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.POJOMatchTypeBoot;
import com.singularity.ee.util.dtobootimpl.POJOMatchTypeHelperBoot;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CustomMatchRuleParser
implements CustomRuleTagNames {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.CustomMatchRuleParser");
    private List<TransformationRule> customInterceptorRules = new ArrayList<TransformationRule>();
    private static boolean configFromNodeProperty;

    public CustomMatchRuleParser(String customRulesFile, IJava9Util java9Util, String customMatchRulesFromNodeProperty, boolean isConfigFromNodeProperty) {
        configFromNodeProperty = isConfigFromNodeProperty;
        if (new File(customRulesFile).exists() || configFromNodeProperty) {
            try {
                Document xmlDoc;
                if (configFromNodeProperty) {
                    logger.info("Applying custom interceptors from Node Property.");
                    xmlDoc = XMLParseUtility.getXmlDocumentFromString((String)customMatchRulesFromNodeProperty);
                } else {
                    logger.info("Applying custom interceptors from xml File " + customRulesFile);
                    xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)new File(customRulesFile));
                }
                List customInterceptorRuleElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)xmlDoc.getDocumentElement(), (String)"custom-interceptor");
                for (Element customInterceptorElement : customInterceptorRuleElements) {
                    TransformationRule rule = CustomMatchRuleParser.parse(customInterceptorElement, customRulesFile, java9Util);
                    if (rule == null) continue;
                    this.customInterceptorRules.add(rule);
                }
            }
            catch (Exception e) {
                logger.info("Could not parse Custom BCI Match Rules ", e);
            }
        }
    }

    public List<TransformationRule> getCustomRules() {
        return this.customInterceptorRules;
    }

    public static TransformationRule parse(Element ruleElement, String xmlFileName, IJava9Util java9Util) {
        String interceptorName = XMLParseUtility.getTextForTagForElement((Node)ruleElement, (String)"interceptor-class-name");
        String interceptorClassName = InterceptorClassRegistryBoot.getInterceptorClassName((String)interceptorName);
        if (interceptorClassName == null) {
            if (configFromNodeProperty) {
                logger.warn(String.format("Interceptor named %s referenced in Node Property 'custom-interceptors-rules'could not be found - %s tag is ignored", interceptorName, "interceptor-class-name"));
            } else {
                logger.warn(String.format("Interceptor named %s referenced in XML file %s could not be found - %s tag is ignored", interceptorName, xmlFileName, "interceptor-class-name"));
            }
            return null;
        }
        Element matchClassElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)ruleElement, (String)"match-class");
        POJOMatchTypeBoot type = POJOMatchTypeHelperBoot.getEnumValue(matchClassElement.getAttribute("type"));
        String className = XMLParseUtility.getTextForTagForElement((Node)matchClassElement, (String)"name");
        Element matchMethodElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)ruleElement, (String)"match-method");
        String methodName = XMLParseUtility.getTextForTagForElement((Node)matchMethodElement, (String)"name");
        String paramDesc = XMLParseUtility.getTextForTagForElement((Node)matchMethodElement, (String)"param-desc");
        String returnType = XMLParseUtility.getTextForTagForElement((Node)matchMethodElement, (String)"return-type");
        String moduleName = XMLParseUtility.getTextForTagForElement((Node)matchMethodElement, (String)"module-name");
        Element configuration = XMLParseUtility.getFirstDirectChildUnderWithName((Node)ruleElement, (String)"configuration");
        ClassMethodFilter filter = TransformationRuleHelper.createClassMethodFilter(type, className, methodName, CustomMatchRuleParser.parseParamDesc(paramDesc), false, returnType, moduleName, logger, java9Util);
        Class<? extends AMethodInterceptor> interceptorClass = TransformationRuleHelper.lookupInterceptorClass(interceptorClassName);
        if (interceptorClass != null) {
            TransformationRule rule = new TransformationRule(filter, interceptorClass);
            if (configuration != null) {
                rule.setTransformationRuleContext(new CustomRuleConfigurationContext(configuration));
            }
            return rule;
        }
        logger.warn("Invalid interceptor class name:" + interceptorClassName);
        return null;
    }

    private static List<String> parseParamDesc(String desc) {
        return StringOperations.parseCommaSeparatedString((String)desc);
    }
}

