/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.inline.template;

import com.singularity.ee.agent.appagent.kernel.config.acnp.NodeProperty;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodePropertyListener;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceConfig;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceInfo;
import com.singularity.ee.agent.appagent.services.bciengine.inline.template.InlineTemplateManager;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.string.StringOperations;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@NodePropertyListener(id="InlineRetransformationHelper")
public class InlineRetransformationHelper {
    private static final IADLogger agentLogger = ADLoggerFactory.getLogger("com.singularity.bci.InlineTemplateManager");
    private final IBCIEngineService bciEngine;
    private final IAgentScheduledExecutorService globalScheduler;
    private final InlineTemplateManager inlineTemplateManager;

    @Inject
    public InlineRetransformationHelper(IConfigManager configManager, IAgentSchedulerManager agentSchedulerManager, IBCIEngineService bciEngine, InlineTemplateManager inlineTemplateManager) {
        this.bciEngine = bciEngine;
        this.globalScheduler = agentSchedulerManager.getAgentGlobalScheduler();
        this.inlineTemplateManager = inlineTemplateManager;
        configManager.registerConfigPropertyChangeListener(this);
        String currentPropValue = InlineRetransformationHelper.getCurrentPropertyValue("should-inline-interceptors", configManager);
        if (!StringOperations.isEmpty((String)currentPropValue)) {
            boolean shouldInline = StringOperations.safeParseBoolean((String)currentPropValue, (boolean)false);
            inlineTemplateManager.setShouldInline(shouldInline);
        }
    }

    public void retransformClassesForConfigUpdate(String[] classesToRetransform) {
        if (!this.bciEngine.isRetransformClassesSupported()) {
            return;
        }
        if (classesToRetransform.length > 0) {
            this.globalScheduler.schedule(new InlineRetransformTask(this.bciEngine, classesToRetransform), 0L, AgentTimeUnit.MILLISECONDS);
        }
    }

    @NodeProperty(key="should-inline-interceptors", description="Enable/Disable Inline transformation", defaultValue="false")
    public void setShouldInline(boolean newShouldInline) {
        if (newShouldInline != this.inlineTemplateManager.isShouldInline()) {
            this.inlineTemplateManager.setShouldInline(newShouldInline);
            String[] classesToRetransform = this.inlineTemplateManager.getAndResetInlineBCIdClasses();
            this.retransformClassesForConfigUpdate(classesToRetransform);
        }
    }

    private static final String getCurrentPropertyValue(String propName, IConfigManager configMgr) {
        Map<String, String> props;
        IServiceConfig config;
        String returnValue = null;
        IServiceInfo serviceInfo = configMgr.getServiceConfig("BCIEngine");
        if (serviceInfo != null && (config = serviceInfo.getConfiguration()) != null && (props = config.getConfigProperties()) != null) {
            returnValue = props.get(propName);
        }
        return returnValue;
    }

    private static class InlineRetransformTask
    implements IAgentRunnable {
        private final IBCIEngineService bciEngine;
        private final String[] classesToRetransform;

        public InlineRetransformTask(IBCIEngineService bciEngine, String[] classesToRetransform) {
            this.bciEngine = bciEngine;
            this.classesToRetransform = classesToRetransform;
        }

        public void run() {
            BCTLoggerUtil.println("shouldInline value changed, following classes will be retransformed");
            for (String nextClassName : this.classesToRetransform) {
                BCTLoggerUtil.println("     " + nextClassName);
            }
            try {
                this.bciEngine.retransformClassNames(this.classesToRetransform);
            }
            catch (UnableToRetransformException e) {
                e.sendError(agentLogger, "InlineTemplateManager.retransformClasses()");
            }
        }
    }
}

