/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.inline.template;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.IInlineInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InlineTemplateManager {
    private static final IInlineInterceptor DUMMY_INTERCEPTOR = new IInlineInterceptor(){

        public void methodStart(Object invokedObject, String className, String methodName, Object[] paramValues, int transformationId, Object additionalArgument) {
        }

        public void methodEnd(Object invokedObject, String className, String methodName, Object[] paramValues, Throwable thrownException, Object returnValue, int transformationId, Object additionalArgument) {
        }
    };
    private boolean shouldInline = false;
    private final Set<String> inlineBCIdClasses = new HashSet<String>();
    private final Map<String, IInlineInterceptor> mapOfInlineInterceptors = new HashMap<String, IInlineInterceptor>();

    @Inject
    public InlineTemplateManager() {
    }

    public boolean isShouldInline() {
        return this.shouldInline;
    }

    public void setShouldInline(boolean shouldInline) {
        this.shouldInline = shouldInline;
        BCTLoggerUtil.println("InlineTemplateManager shouldInline value is " + Boolean.toString(shouldInline));
    }

    public synchronized boolean recordAndCheckShouldInline(String className) {
        this.inlineBCIdClasses.add(className.replace('/', '.'));
        return this.shouldInline;
    }

    public synchronized IInlineInterceptor getInterceptor(String interceptorClassName, ClassLoader classLoader) {
        IInlineInterceptor returnObject = this.mapOfInlineInterceptors.get(interceptorClassName);
        if (returnObject == null) {
            try {
                Class<?> clazz = classLoader.loadClass(interceptorClassName);
                returnObject = (IInlineInterceptor)clazz.newInstance();
                this.mapOfInlineInterceptors.put(interceptorClassName, returnObject);
            }
            catch (Throwable t) {
                BCTLoggerUtil.printStackTrace(t);
                this.mapOfInlineInterceptors.put(interceptorClassName, DUMMY_INTERCEPTOR);
            }
        } else if (returnObject == DUMMY_INTERCEPTOR) {
            returnObject = null;
        }
        return returnObject;
    }

    public synchronized String[] getAndResetInlineBCIdClasses() {
        String[] classesToRetransform = this.inlineBCIdClasses.toArray(new String[this.inlineBCIdClasses.size()]);
        this.inlineBCIdClasses.clear();
        return classesToRetransform;
    }
}

