/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.log;

import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;

abstract class ABCTLogger {
    private static final int MAX_LENGTH_IN_ONE_LINE = 2000;
    protected static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.BCTLogger");
    private final StringBuilder currentLine = new StringBuilder();

    static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    static boolean isInfoEnabled() {
        return logger.isInfoEnabled();
    }

    static boolean isTraceEnabled() {
        return logger.isTraceEnabled();
    }

    protected ABCTLogger() {
    }

    abstract void setClassName(String var1);

    protected abstract void emit(ADLevel var1, String var2);

    protected abstract void emit(ADLevel var1, String var2, Throwable var3);

    abstract void flush();

    void print(String s) {
        if (this.currentLine.length() + s.length() > 2000) {
            this.println("-max-length-2000-reached-");
        }
        this.currentLine.append(s);
    }

    void println(String s) {
        this.println(s, ADLevel.INFO);
    }

    void println(String s, ADLevel level) {
        this.currentLine.append(s);
        this.emit(level, this.currentLine.toString());
        this.currentLine.setLength(0);
    }

    private void flushLine() {
        if (this.currentLine.length() > 0) {
            this.println("");
        }
    }

    void error(String msg) {
        this.flushLine();
        this.emit(ADLevel.ERROR, msg);
    }

    void error(String msg, Throwable t) {
        this.flushLine();
        this.emit(ADLevel.ERROR, msg, t);
    }

    void info(String msg) {
        this.flushLine();
        this.emit(ADLevel.INFO, msg);
        logger.info(msg);
    }

    void trace(String msg) {
        this.flushLine();
        this.emit(ADLevel.TRACE, msg);
        logger.trace(msg);
    }

    void warn(String msg) {
        this.flushLine();
        this.emit(ADLevel.WARN, msg);
    }
}

