/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.log;

import com.singularity.ee.agent.appagent.services.bciengine.log.ABCTLogger;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggingThread;
import com.singularity.ee.agent.appagent.services.bciengine.log.DeferredBCTLogger;
import com.singularity.ee.agent.appagent.services.bciengine.log.PassThroughBCTLogger;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.thread.ThreadUtil;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;

public class BCTLoggerUtil {
    private static final boolean DIRECT_LOGGING = Boolean.getBoolean("appdynamics.agent.bct.useDirectLogging");
    private static ThreadLocal<ABCTLogger> myLogger = new ThreadLocal();
    public static ThreadLocal<Boolean> traceEnabledForCurrentClass = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static void useAgentScheduler(IAgentScheduledThreadPoolExecutor agentScheduler) {
        BCTLoggingThread.setAgentScheduler(agentScheduler);
    }

    public static void provideLogger(String className) {
        ABCTLogger logger = BCTLoggerUtil.getLogger();
        logger.setClassName(className == null ? "--no-class-name--" : className);
    }

    private static ABCTLogger getLogger() {
        ABCTLogger logger = myLogger.get();
        if (logger == null) {
            logger = DIRECT_LOGGING ? new PassThroughBCTLogger() : new DeferredBCTLogger();
            myLogger.set(logger);
        }
        return logger;
    }

    public static void flushLogger() {
        BCTLoggerUtil.getLogger().flush();
    }

    public static boolean isTraceEnabledForCurrentClass() {
        return traceEnabledForCurrentClass.get();
    }

    public static void printStackTrace(Throwable e) {
        BCTLoggerUtil.println(BCTLoggerUtil.stackTraceFor(e));
    }

    private static String stackTraceFor(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        return ThreadUtil.getUnfilteredADStackSummary((StackTraceElement[])elements);
    }

    public static void println(String s) {
        BCTLoggerUtil.println(s, ADLevel.INFO);
    }

    public static void println(String s, ADLevel level) {
        BCTLoggerUtil.getLogger().println(s, level);
    }

    public static void print(String s) {
        BCTLoggerUtil.getLogger().print(s);
    }

    public static void println(String s, boolean forceAddToBuffer) {
        BCTLoggerUtil.println(s);
    }

    public static void printlnWithPrefix(String s, ADLevel level) {
        BCTLoggerUtil.println(s, level);
    }

    public static void excludeCustomClass(String s) {
        BCTLoggerUtil.println(s);
    }

    public static void excludeClassesFromRetransformation(String s) {
        BCTLoggerUtil.println(s);
    }

    public static void includeSystemClass(String s) {
        BCTLoggerUtil.print("Including system class [");
        BCTLoggerUtil.print(s);
        BCTLoggerUtil.println("]");
    }

    public static void excludeSystemClass(String s) {
        BCTLoggerUtil.print("Excluding system class [");
        BCTLoggerUtil.print(s);
        BCTLoggerUtil.println("]");
    }

    public static void error(String msg) {
        BCTLoggerUtil.getLogger().error(msg);
    }

    public static void error(String msg, Throwable t) {
        BCTLoggerUtil.getLogger().error(msg, t);
    }

    public static void info(String msg) {
        BCTLoggerUtil.getLogger().info(msg);
    }

    public static void trace(String msg) {
        BCTLoggerUtil.getLogger().trace(msg);
    }

    public static void warn(String s) {
        BCTLoggerUtil.getLogger().warn(s);
    }

    public static boolean isDebugEnabled() {
        return ABCTLogger.isDebugEnabled();
    }

    public static boolean isInfoEnabled() {
        return ABCTLogger.isInfoEnabled();
    }

    public static boolean isTraceEnabled() {
        return ABCTLogger.isTraceEnabled();
    }

    public static void applyingMethodInterceptor(String className, String methodName, String interceptorDescription, int transformationId) {
        BCTLoggerUtil.println("\t\tApplying method interceptor with description " + interceptorDescription + " at " + className + "." + methodName + " id:" + transformationId);
    }

    public static void applyingCodeInterceptor(String className, String methodName, String interceptorName, int transformationId, int lineNumber) {
        BCTLoggerUtil.println("\t\tApplying code interceptor " + interceptorName + " at " + className + "." + methodName + " id:" + transformationId + " line:" + lineNumber);
    }

    public static void matchingMethod(String methodInfo) {
        BCTLoggerUtil.println("\tMatching method " + methodInfo);
    }

    public static void classMatchFound(boolean b) {
        BCTLoggerUtil.println(b ? " : Class match found." : " : No class match found.");
    }

    public static void classIdentified(String className) {
        BCTLoggerUtil.println("Class Identified :" + className);
    }

    public static void interceptorDisabled(String interceptorName, String rule) {
        BCTLoggerUtil.println("Interceptor disabled [" + interceptorName + "] skip rule: [" + rule + "]", true);
    }

    public static void matchingClassname(String name) {
        BCTLoggerUtil.print("Matching class name " + name);
    }

    public static void matchingClassnameIdentification(String name) {
        BCTLoggerUtil.println("Matching class name " + name);
    }

    public static void matchingClassBytecode() {
        BCTLoggerUtil.print("\tMatching class bytecode.");
    }

    public static void matchingRuntimeClass() {
        BCTLoggerUtil.print("\tMatching runtime class.");
    }

    public static void excludeMethod(String methodInfo) {
        BCTLoggerUtil.println("\tMethod excluded: " + methodInfo);
    }

    public static void methodLimitedFromTransformation(String reason) {
        BCTLoggerUtil.println("\t    Method excluded because " + reason);
    }
}

