/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.log;

import com.singularity.ee.agent.appagent.services.bciengine.log.DeferredBCTLogger;
import com.singularity.ee.agent.appagent.services.bciengine.log.DeferredLogEntry;
import com.singularity.ee.agent.appagent.services.bciengine.log.Envelope;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class BCTLoggingThread
extends Thread {
    private static final String FLUSHING_THREAD_NAME = "AD Deferred BCI Logger";
    private static final int POLL_TIMEOUT = 10;
    private static final int MAX_IDLE_TIME_BEFORE_THREAD_TERMINATION = 300;
    private static final int SCHEDULED_TASK_INTERVAL = 1;
    private static IAgentScheduledThreadPoolExecutor agentScheduler;
    private final Queue<String> underservedClasses;
    private final BlockingQueue<Envelope> pendingLog;
    private final IADLogger logger;
    private int idleTime;

    BCTLoggingThread(BlockingQueue<Envelope> pendingLog, Queue<String> underservedClasses, IADLogger logger) {
        super(FLUSHING_THREAD_NAME);
        this.pendingLog = pendingLog;
        this.underservedClasses = underservedClasses;
        this.logger = logger;
    }

    static void setAgentScheduler(IAgentScheduledThreadPoolExecutor scheduler) {
        agentScheduler = scheduler;
    }

    @Override
    public void run() {
        IAgentRunnable drainingTask = this.createDrainingTask();
        try {
            this.serveApplicationStartup(drainingTask);
            this.logger.info("Shutting down the dedicated BCTLogger thread");
            agentScheduler.scheduleWithFixedDelay(drainingTask, 1L, 1L, AgentTimeUnit.SECONDS);
        }
        catch (Throwable t) {
            this.logger.fatal("AD Deferred BCI Logger is dying", t);
        }
    }

    IAgentRunnable createDrainingTask() {
        return new DrainingTask();
    }

    private void serveApplicationStartup(IAgentRunnable drainingTask) {
        boolean keepThreadAlive = true;
        while (keepThreadAlive) {
            drainingTask.run();
            try {
                Envelope env = this.pendingLog.poll(10L, TimeUnit.SECONDS);
                if (env != null) {
                    this.idleTime = 0;
                    this.drainEnvelope(env);
                    continue;
                }
                this.idleTime += 10;
                if (agentScheduler == null || this.idleTime < 300) continue;
                keepThreadAlive = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void whineAbout(String className) {
        if (className != DeferredBCTLogger.NO_CLASS_NAME) {
            this.logger.info("OOPS, unable to log any details on transforming " + className);
        } else {
            this.logger.info("OOPS, dropping log entries because of agent overload");
        }
    }

    private void drainEnvelope(Envelope env) {
        Thread thread = Thread.currentThread();
        String threadTrueName = thread.getName();
        thread.setName("~" + env.getReportingThreadName());
        for (DeferredLogEntry entry : env.entries) {
            if (entry.exception == null) {
                this.logger.log(entry.level, entry.message);
                continue;
            }
            this.logger.log(entry.level, entry.message, entry.exception);
        }
        thread.setName(threadTrueName);
    }

    private class DrainingTask
    implements IAgentRunnable {
        private DrainingTask() {
        }

        public void run() {
            String className;
            Envelope env;
            while ((env = (Envelope)BCTLoggingThread.this.pendingLog.poll()) != null) {
                BCTLoggingThread.this.drainEnvelope(env);
            }
            while ((className = (String)BCTLoggingThread.this.underservedClasses.poll()) != null) {
                BCTLoggingThread.this.whineAbout(className);
            }
        }
    }
}

