/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.log;

import com.singularity.ee.agent.appagent.services.bciengine.log.ABCTLogger;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggingThread;
import com.singularity.ee.agent.appagent.services.bciengine.log.Envelope;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.util.string.StringOperations;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

class DeferredBCTLogger
extends ABCTLogger {
    private static final int DEFAULT_BUFFER_SIZE = 200;
    private static final int MAX_WAIT_FOR_BUFFER_MS = 100;
    private static final Queue<String> underservedClasses = new ConcurrentLinkedQueue<String>();
    private static final BlockingQueue<Envelope> pendingLog;
    static final String NO_CLASS_NAME;
    private final String threadName = Thread.currentThread().getName();
    private String className;
    private Envelope currentEnvelope;

    DeferredBCTLogger() {
    }

    @Override
    void setClassName(String className) {
        this.className = className;
    }

    private Envelope getEnvelope() {
        if (this.currentEnvelope == null) {
            this.currentEnvelope = new Envelope(this.threadName);
        }
        return this.currentEnvelope;
    }

    @Override
    protected void emit(ADLevel level, String s) {
        this.emit(level, s, null);
    }

    @Override
    protected void emit(ADLevel level, String s, Throwable t) {
        Envelope e = this.getEnvelope();
        e.append(level, s, t);
    }

    @Override
    void flush() {
        if (this.currentEnvelope != null && !this.currentEnvelope.entries.isEmpty()) {
            boolean success = false;
            try {
                success = pendingLog.offer(this.currentEnvelope, 100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!success) {
                underservedClasses.offer(this.className == null ? NO_CLASS_NAME : this.className);
            }
            this.currentEnvelope = null;
        }
        this.setClassName(null);
    }

    static {
        String property = System.getProperty("appdynamics.agent.bct.log.bufferSize");
        int bufferSize = StringOperations.safeParseInteger((String)property, (int)200);
        pendingLog = new ArrayBlockingQueue<Envelope>(bufferSize < 1 ? 1 : bufferSize);
        BCTLoggingThread t = new BCTLoggingThread(pendingLog, underservedClasses, logger);
        t.setDaemon(true);
        t.start();
        NO_CLASS_NAME = new String();
    }
}

