/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.network;

import com.singularity.ee.agent.appagent.boot.transactionmonitor.IBootTransactionContext;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IInlineInterceptor;
import java.util.Stack;

public abstract class ASocketInterceptorTemplate
implements IInlineInterceptor {
    protected static ThreadLocal<SavedVars> refToCurrentTopOfStack;
    protected static ThreadLocal<Stack<SavedVars>> refToStack;

    protected ASocketInterceptorTemplate() {
        refToCurrentTopOfStack = new ThreadLocal();
        refToStack = new ThreadLocal();
    }

    protected static void setStartTime(long startTime) {
        SavedVars sv = refToCurrentTopOfStack.get();
        if (sv != null) {
            sv.startTime = startTime;
        }
    }

    protected static long getStartTime() {
        SavedVars sv = refToCurrentTopOfStack.get();
        if (sv != null) {
            return sv.startTime;
        }
        return 0L;
    }

    protected static byte[] getarg0() {
        SavedVars sv = refToCurrentTopOfStack.get();
        if (sv != null) {
            return sv.buffer;
        }
        return null;
    }

    protected static int getarg2() {
        SavedVars sv = refToCurrentTopOfStack.get();
        if (sv != null) {
            return sv.len;
        }
        return 0;
    }

    protected static IBootTransactionContext getCTC() {
        SavedVars sv = refToCurrentTopOfStack.get();
        if (sv != null) {
            return sv.ctc;
        }
        return null;
    }

    protected static void setCTC(IBootTransactionContext ctc) {
        SavedVars sv = refToCurrentTopOfStack.get();
        if (sv != null) {
            sv.ctc = ctc;
        }
    }

    public void methodStart(Object invokedObject, String className, String methodName, Object[] paramValues, int transformationId, Object additionalArgument) {
        SavedVars newSavedVars = new SavedVars(paramValues);
        Stack<SavedVars> currentStack = refToStack.get();
        if (currentStack == null) {
            currentStack = new Stack();
            refToStack.set(currentStack);
        }
        currentStack.push(newSavedVars);
        refToCurrentTopOfStack.set(newSavedVars);
        this.methodEntryTemplateNonInline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void methodEnd(Object invokedObject, String className, String methodName, Object[] paramValues, Throwable thrownException, Object returnValue, int transformationId, Object additionalArgument) {
        Stack<SavedVars> currentStack = refToStack.get();
        if (currentStack != null && currentStack.size() > 0) {
            try {
                if (thrownException == null && returnValue != null) {
                    SavedVars sv = refToCurrentTopOfStack.get();
                    sv.returnValue = ((Number)returnValue).longValue();
                }
                if (thrownException == null) {
                    this.methodExitTemplateNonInline();
                } else {
                    this.methodExitExceptionTemplateNonInline();
                }
                currentStack.pop();
            }
            catch (Throwable throwable) {
                currentStack.pop();
                refToCurrentTopOfStack.set(currentStack.size() > 0 ? currentStack.peek() : null);
                throw throwable;
            }
            refToCurrentTopOfStack.set(currentStack.size() > 0 ? currentStack.peek() : null);
        }
    }

    protected abstract void methodExitTemplateNonInline();

    protected abstract void methodEntryTemplateNonInline();

    protected abstract void methodExitExceptionTemplateNonInline();

    public class SavedVars {
        byte[] buffer;
        int offset;
        int len;
        long returnValue;
        long startTime;
        IBootTransactionContext ctc;

        SavedVars(Object[] args) {
            this.buffer = (byte[])args[0];
            this.offset = (Integer)args[1];
            this.len = (Integer)args[2];
        }

        public long getReturnValue() {
            return this.returnValue;
        }
    }
}

