/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.pojo.util;

import com.singularity.ee.agent.appagent.kernel.AgentProperties;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.util.HashSet;
import java.util.Set;

public abstract class ABCIRuleApplier {
    protected IADLogger logger;
    protected IBCIEngineService bciEngine;
    private final Set<AClassTransformationRule> currentTransformationRules = new HashSet<AClassTransformationRule>();
    private final Set<AClassTransformationRule> olderTransformationRules = new HashSet<AClassTransformationRule>();
    protected boolean needsRetransformInPreMain;
    private boolean checkDuplicateRules = false;

    public ABCIRuleApplier(IADLogger logger, IBCIEngineService bciEngine, boolean needsRetransformInPreMain) {
        this.logger = logger;
        this.bciEngine = bciEngine;
        this.needsRetransformInPreMain = needsRetransformInPreMain;
    }

    public ABCIRuleApplier(IADLogger logger, IBCIEngineService bciEngine) {
        this.logger = logger;
        this.bciEngine = bciEngine;
    }

    public void setCheckDuplicateRules(boolean checkDuplicateRules) {
        this.checkDuplicateRules = checkDuplicateRules;
    }

    public void startApplyingNewSet() {
        if (this.isInPreMain() && !this.needsRetransformInPreMain) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In premain: " + this.isInPreMain() + ", Before applying new rules copying to old rules");
            for (AClassTransformationRule currentTransformationRule : this.currentTransformationRules) {
                this.logger.debug("[" + currentTransformationRule + "]");
            }
        }
        this.olderTransformationRules.clear();
        this.olderTransformationRules.addAll(this.currentTransformationRules);
        this.currentTransformationRules.clear();
    }

    public void startModifyingCurrentSet() {
        if (this.isInPreMain() && !this.needsRetransformInPreMain) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In premain:" + this.isInPreMain() + ", Before modifying current rules copying to old rules ");
            for (AClassTransformationRule currentTransformationRule : this.currentTransformationRules) {
                this.logger.debug("[" + currentTransformationRule + "]");
            }
        }
        this.olderTransformationRules.clear();
        this.olderTransformationRules.addAll(this.currentTransformationRules);
    }

    public boolean finishApplyingNewSet() throws UnableToRetransformException {
        if (this.isInPreMain() && !this.needsRetransformInPreMain) {
            this.logger.debug("In premain and 'needsRetransformInPreMain' setting is not set.");
            return false;
        }
        boolean reTransformRequired = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In premain:" + this.isInPreMain() + ", finish applying new rule set");
            this.logger.debug("Existing rule set:");
            for (AClassTransformationRule aClassTransformationRule : this.olderTransformationRules) {
                this.logger.debug("[" + aClassTransformationRule + "]");
            }
            this.logger.debug("Current rule set:");
            for (AClassTransformationRule aClassTransformationRule : this.currentTransformationRules) {
                this.logger.debug("[" + aClassTransformationRule + "]");
            }
        }
        HashSet<AClassTransformationRule> addedRules = new HashSet<AClassTransformationRule>();
        for (AClassTransformationRule crule : this.currentTransformationRules) {
            if (this.olderTransformationRules.contains(crule)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Rule [" + crule + "] already exists in the old rule set, ignoring.");
                continue;
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Rule [" + crule + "] is a new rule, will attempt to register in BCIEngine.");
                }
                if (this.checkDuplicateRules) {
                    this.bciEngine.geTransformationRuleEngine().registerTransformationRuleIfAbsent(crule);
                } else {
                    this.bciEngine.geTransformationRuleEngine().registerTransformationRule(crule);
                }
                addedRules.add(crule);
                reTransformRequired = true;
            }
            catch (IllegalArgumentException e) {
                this.logger.info(e.getMessage());
            }
        }
        HashSet<AClassTransformationRule> hashSet = new HashSet<AClassTransformationRule>();
        for (AClassTransformationRule orule : this.olderTransformationRules) {
            if (this.currentTransformationRules.contains(orule)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Old rule [" + orule + "] is already in the rule set, ignoring.");
                continue;
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Old rule [" + orule + "] is removed from the new set, will attempt to delete from BCIEngine");
                }
                this.bciEngine.geTransformationRuleEngine().unregisterTransformationRule(orule);
                hashSet.add(orule);
                reTransformRequired = true;
            }
            catch (IllegalArgumentException e) {
                this.logger.info(e.getMessage());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Transformation Rules ADDED for retransform ");
            for (AClassTransformationRule transformationRule : addedRules) {
                this.logger.debug("[" + transformationRule + "]");
            }
            this.logger.debug("Transformation Rules REMOVED for retransform ");
            for (AClassTransformationRule transformationRule : hashSet) {
                this.logger.debug("[" + transformationRule + "]");
            }
        }
        if (reTransformRequired) {
            this.bciEngine.retransformClassesForRule(addedRules, hashSet, this.isInPreMain() && this.needsRetransformInPreMain);
        }
        return addedRules.size() + hashSet.size() > 0;
    }

    protected void addTransformationRule(AClassTransformationRule rule) {
        this.currentTransformationRules.add(rule);
    }

    public void removeTransformationRule(AClassTransformationRule rule) {
        this.currentTransformationRules.remove(rule);
    }

    public Set<AClassTransformationRule> getCurrentTransformationRules() {
        return this.currentTransformationRules;
    }

    protected boolean isInPreMain() {
        return AgentProperties.getInstance().isInPreMain();
    }
}

