/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.pojo.util;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleHelper;
import com.singularity.ee.agent.appagent.services.bciengine.custom.interceptors.BCIMatchRule;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.ABCIRuleApplier;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.POJOMatchTypeBoot;

public class BCIRuleApplier
extends ABCIRuleApplier {
    private IJava9Util java9Util;

    public BCIRuleApplier(IADLogger logger, IBCIEngineService bciEngine) {
        super(logger, bciEngine);
    }

    public BCIRuleApplier(IADLogger logger, IBCIEngineService bciEngine, IJava9Util java9Util) {
        this(logger, bciEngine, false, java9Util);
    }

    public BCIRuleApplier(IADLogger logger, IBCIEngineService bciEngine, boolean needsRetransformInPreMain) {
        this(logger, bciEngine, needsRetransformInPreMain, null);
    }

    public BCIRuleApplier(IADLogger logger, IBCIEngineService bciEngine, boolean needsRetransformInPreMain, IJava9Util java9Util) {
        super(logger, bciEngine, needsRetransformInPreMain);
        this.java9Util = java9Util;
    }

    public void applyInterceptor(BCIMatchRule matchRule) {
        AClassTransformationRule rule = this.getTransformationRuleForBCIMatchRule(matchRule);
        if (rule != null) {
            this.applyInterceptor(rule);
        }
    }

    public void applyInterceptorIfRequired(BCIMatchRule matchRule) {
        AClassTransformationRule rule = this.getTransformationRuleForBCIMatchRule(matchRule);
        if (rule != null) {
            this.applyInterceptorIfRequired(rule);
        }
    }

    public AClassTransformationRule getTransformationRuleForBCIMatchRule(BCIMatchRule matchRule) {
        POJOMatchTypeBoot matchType = matchRule.getMatchClassType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("applying interceptor for match type [" + (Object)((Object)matchType) + "]");
        }
        ClassMethodFilter classMethodFilter = TransformationRuleHelper.createClassMethodFilter(matchRule.getMatchClassType(), matchRule.getClassName(), matchRule.getMethodName(), matchRule.getMethodParams(), matchRule.isMatchNoArgsOnly(), matchRule.getReturnType(), matchRule.getModuleName(), this.logger, this.java9Util);
        return this.getTransformationRuleForBCIMatchRule(matchRule, classMethodFilter);
    }

    private AClassTransformationRule getTransformationRuleForBCIMatchRule(BCIMatchRule matchRule, ClassMethodFilter classMethodFilter) {
        Class<? extends AMethodInterceptor> interceptorClass = matchRule.getInterceptorClass();
        if (interceptorClass == null) {
            String interceptorClassName = matchRule.getInterceptorClassName();
            if (interceptorClassName != null) {
                interceptorClass = TransformationRuleHelper.lookupInterceptorClass(interceptorClassName);
                if (interceptorClass == null) {
                    this.logger.warn("Interceptor [" + interceptorClassName + "] not registered");
                    return null;
                }
            } else {
                this.logger.warn("interceptor class name is null for rule [" + matchRule + "]");
                return null;
            }
        }
        TransformationRule rule = new TransformationRule(classMethodFilter, interceptorClass);
        if (matchRule.getRuleContext() != null) {
            rule.setTransformationRuleContext(matchRule.getRuleContext());
        }
        return rule;
    }

    public void applyInterceptor(AClassTransformationRule rule) {
        if (this.isInPreMain() && !this.needsRetransformInPreMain) {
            this.bciEngine.geTransformationRuleEngine().registerTransformationRule(rule);
        }
        this.addTransformationRule(rule);
    }

    public void applyInterceptorIfRequired(AClassTransformationRule rule) {
        if (this.isInPreMain() && !this.needsRetransformInPreMain) {
            this.bciEngine.geTransformationRuleEngine().registerTransformationRuleIfAbsent(rule);
        }
        this.addTransformationRule(rule);
    }

    public void applyInterceptors(AClassTransformationRule[] rules) {
        for (AClassTransformationRule rule : rules) {
            this.applyInterceptor(rule);
        }
    }
}

