/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.ruleset;

import com.singularity.ee.agent.appagent.kernel.AgentProperties;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.appagent.kernel.spi.IServicePropertyListener;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.BCIRuleApplier;
import com.singularity.ee.agent.appagent.services.bciengine.ruleset.ARuleSetApplier;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.util.Collection;

public abstract class ADynamicRuleSetApplier
extends ARuleSetApplier
implements IServicePropertyListener {
    private final AgentProperties agentProperties;
    private boolean initialized = false;
    private boolean started = false;

    public ADynamicRuleSetApplier(IADLogger logger, AgentProperties agentProperties) {
        super(logger);
        this.agentProperties = agentProperties;
    }

    public void init(IConfigManager configManager) {
        this.initialized = true;
        this.registerConfigForUpdate(configManager);
    }

    public void start(IBCIEngineService bciEngine) {
        if (!this.initialized) {
            throw new RuntimeException("start cannot be called before init");
        }
        this.started = true;
        this.statefulRuleApplier = new BCIRuleApplier(this.logger, bciEngine);
    }

    @Override
    public final void servicePropertyChanged(String serviceName, String propertyName, String newPropertyValue) {
        if (this.updateConfigValue(propertyName, newPropertyValue) && !this.agentProperties.isInPreMain() && this.started) {
            this.applyRules();
        }
    }

    private void registerConfigForUpdate(IConfigManager configManager) {
        Collection<String> dependentConfigs = this.getDependentConfigs();
        if (dependentConfigs != null && dependentConfigs.size() > 0) {
            configManager.registerConfigPropertyChangeListener("TransactionMonitoringService", dependentConfigs, (IServicePropertyListener)this);
        }
    }

    protected abstract boolean updateConfigValue(String var1, String var2);

    protected abstract Collection<String> getDependentConfigs();

    public boolean isStarted() {
        return this.started;
    }
}

