/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.ruleset;

import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.BCIRuleApplier;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.ruleset.RuleSet;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.util.log4j.IADLogger;

public abstract class ARuleSetApplier {
    protected final IADLogger logger;
    protected BCIRuleApplier statefulRuleApplier;

    public ARuleSetApplier(IADLogger logger) {
        this.logger = logger;
    }

    public void applyRules() {
        RuleSet ruleSet = this.getRuleSet();
        this.logger.info("Applying rules: " + ruleSet.getContext());
        this.statefulRuleApplier.startApplyingNewSet();
        for (AClassTransformationRule rule : ruleSet) {
            this.statefulRuleApplier.applyInterceptor(rule);
        }
        try {
            this.statefulRuleApplier.finishApplyingNewSet();
        }
        catch (UnableToRetransformException e) {
            e.sendError(this.logger, ruleSet.getContext());
        }
    }

    public void unapplyRules() {
        RuleSet ruleSet = this.getRuleSet();
        this.logger.info("Un-applying rules: " + ruleSet.getContext());
        this.statefulRuleApplier.startApplyingNewSet();
        for (AClassTransformationRule rule : ruleSet) {
            this.statefulRuleApplier.removeTransformationRule(rule);
        }
        try {
            this.statefulRuleApplier.finishApplyingNewSet();
        }
        catch (UnableToRetransformException e) {
            e.sendError(this.logger, ruleSet.getContext());
        }
    }

    protected abstract RuleSet getRuleSet();
}

