/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi;

import com.singularity.ee.agent.appagent.services.bciengine.spi.ATransformationRuleContext;
import com.singularity.ee.agent.appagent.services.bciengine.spi.DefaultTransformationLimiter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ITransformationLimiter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ITransformationRuleListener;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationLimitExceededException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodExcludeFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.ModuleNameMatchClassFilter;
import com.singularity.ee.util.collections.EqualsUtil;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AClassTransformationRule
implements Cloneable {
    protected ClassMethodFilter filter;
    private final ClassMethodExcludeFilter blackListedClassMethodFilter;
    private ClassMethodExcludeFilter excludedClassMethodFilter;
    protected ATransformationRuleContext transformationRuleContext;
    private String dynamicProperty;
    private int exclude;
    private static final int BCI_EXCLUDE_FLAG = 1;
    private final MatchedClassNameTracker matchedClassNameTracker;
    private final ApplyLimitClassNameTracker applyLimitClassNameTracker;
    protected boolean logRetransformation = false;
    public StackTraceElement[] stackTrace;
    private ITransformationLimiter transformationLimiter;
    protected static final ITransformationLimiter DEFAULT_TRANSFORMATION_LIMITER = DefaultTransformationLimiter.getInstance();
    public static final ITransformationLimiter UNLIMITED_TRANSFORMATION_LIMITER = new UnlimitedTransformationLimiter();

    protected AClassTransformationRule(ClassMethodFilter filter, ITransformationLimiter transformationLimiter) {
        this(filter, null, false, null, null, transformationLimiter);
    }

    protected AClassTransformationRule(ClassMethodFilter filter, ATransformationRuleContext context, boolean trackMatches, ClassMethodExcludeFilter blackListedClassMethodFilter, ClassMethodExcludeFilter excludedClassMethodFilter, ITransformationLimiter transformationLimiter) {
        if (filter == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.filter = filter;
        this.transformationRuleContext = context;
        this.matchedClassNameTracker = trackMatches ? new MatchedClassNameTracker() : null;
        this.applyLimitClassNameTracker = new ApplyLimitClassNameTracker();
        this.blackListedClassMethodFilter = blackListedClassMethodFilter == null ? new ClassMethodExcludeFilter() : blackListedClassMethodFilter;
        this.excludedClassMethodFilter = excludedClassMethodFilter == null ? new ClassMethodExcludeFilter() : excludedClassMethodFilter;
        this.transformationLimiter = transformationLimiter;
    }

    public ClassMethodFilter getFilter() {
        return this.filter;
    }

    public ClassMethodExcludeFilter getBlackListedClassMethodFilter() {
        return this.blackListedClassMethodFilter;
    }

    public ClassMethodExcludeFilter getExcludedClassMethodFilter() {
        return this.excludedClassMethodFilter;
    }

    public void setExcludedClassMethodFilter(ClassMethodExcludeFilter excludedClassMethodFilter) {
        this.excludedClassMethodFilter = excludedClassMethodFilter;
    }

    public ATransformationRuleContext getTransformationRuleContext() {
        return this.transformationRuleContext;
    }

    public void setTransformationRuleContext(ATransformationRuleContext transformationRuleContext) {
        this.transformationRuleContext = transformationRuleContext;
    }

    public String getDynamicProperty() {
        return this.dynamicProperty;
    }

    public void setDynamicProperty(String dynamicProperty) {
        this.dynamicProperty = dynamicProperty;
    }

    public void setBCIFixerExclude() {
        this.exclude |= 1;
    }

    public boolean isBCIFixerExcluded() {
        return (this.exclude & 1) == 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.filter.toString();
    }

    public void addModifiedClassName(String className) {
        if (this.matchedClassNameTracker != null) {
            this.matchedClassNameTracker.modifiedClasses.put(className, Boolean.TRUE);
        }
        if (this.applyLimitClassNameTracker != null) {
            if (this.applyLimitClassNameTracker.classNamesAppliedTo.contains((Object)className)) {
                return;
            }
            this.applyLimitClassNameTracker.classNamesAppliedTo.add((Object)className);
        }
        if (this.transformationLimiter != null) {
            this.transformationLimiter.transformationApplied(className, this);
        }
    }

    public Set<String> getModifiedClassNames() {
        return this.matchedClassNameTracker == null ? Collections.emptySet() : this.matchedClassNameTracker.modifiedClassesReadOnly;
    }

    public boolean isTrackingMatches() {
        return this.matchedClassNameTracker != null;
    }

    public int hashCode() {
        int result = this.filter.hashCode();
        if (this.transformationRuleContext != null) {
            result = 31 * result + this.transformationRuleContext.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AClassTransformationRule m = (AClassTransformationRule)o;
        if (!EqualsUtil.safeCompareObjects(this.transformationRuleContext, m.transformationRuleContext)) {
            return false;
        }
        return m.filter.equals(this.filter);
    }

    public boolean isEquivalentTo(AClassTransformationRule otherRule) {
        boolean bReturn = false;
        if (otherRule != null && this.getClass() == otherRule.getClass() && (this.transformationRuleContext == null && otherRule.transformationRuleContext == null || this.transformationRuleContext != null && this.transformationRuleContext.equals(otherRule.transformationRuleContext)) && this.filter.getMethodFilter().equals(otherRule.filter.getMethodFilter())) {
            bReturn = true;
        }
        return bReturn;
    }

    public void checkShouldApplyToClass(String className, ClassLoader classLoader) throws TransformationLimitExceededException {
        if (this.transformationLimiter != null) {
            this.transformationLimiter.checkApply(className, classLoader, this);
        }
    }

    public void notifyRuleListeners(String className, MethodInfo methodInfo, int transformationId) {
        if (this.transformationRuleContext instanceof ITransformationRuleListener) {
            ((ITransformationRuleListener)((Object)this.transformationRuleContext)).onRuleApplied(this, className, methodInfo, transformationId);
        }
    }

    public ITransformationLimiter getTransformationLimiter() {
        return this.transformationLimiter;
    }

    public void setTransformationLimiter(ITransformationLimiter transformationLimiter) {
        if (transformationLimiter == null) {
            throw new IllegalArgumentException("null cannot be used as a TransformationLimiter");
        }
        this.transformationLimiter = transformationLimiter;
    }

    public void setFilter(ClassMethodFilter filter) {
        this.filter = filter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void preLoadReferencedClasses() {
        if (this.filter != null) {
            this.filter.preLoadReferencedClasses();
        }
    }

    public void addModuleNameFilter(ModuleNameMatchClassFilter moduleNameMatchClassFilter) {
        if (this.filter != null) {
            this.filter.addModuleNameFilter(moduleNameMatchClassFilter);
        }
    }

    public boolean isLogRetransformation() {
        return this.logRetransformation;
    }

    private static class ApplyLimitClassNameTracker {
        private final ADConcurrentSet<String> classNamesAppliedTo = new ADConcurrentSet();

        private ApplyLimitClassNameTracker() {
        }
    }

    private static class MatchedClassNameTracker {
        public final Map<String, Boolean> modifiedClasses = new ConcurrentHashMap<String, Boolean>();
        public final Set<String> modifiedClassesReadOnly = Collections.unmodifiableSet(this.modifiedClasses.keySet());

        private MatchedClassNameTracker() {
        }
    }

    private static class UnlimitedTransformationLimiter
    implements ITransformationLimiter {
        UnlimitedTransformationLimiter() {
        }

        @Override
        public void checkApply(String className, ClassLoader classLoader, AClassTransformationRule rule) {
        }

        @Override
        public void transformationApplied(String className, AClassTransformationRule rule) {
        }
    }
}

