/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi;

import com.singularity.ee.util.collections.EqualsUtil;
import com.singularity.ee.util.collections.HashCodeUtil;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import java.util.ArrayList;
import java.util.List;

public class CustomExclude {
    private StringMatchBoot excludeDefinition;
    private List<StringMatchBoot> methodMatches;

    public CustomExclude(StringMatchBoot excludeDefinition) {
        this.excludeDefinition = new StringMatchBoot(excludeDefinition.getMatchType(), excludeDefinition.getMatchPattern().replace(".", "/"));
    }

    public StringMatchBoot getExcludeDefinition() {
        return this.excludeDefinition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (EqualsUtil.compareObjectTypes(this, o)) {
            CustomExclude other = (CustomExclude)o;
            return EqualsUtil.compareObjectFields(new Object[]{this.excludeDefinition}, new Object[]{other.excludeDefinition});
        }
        return false;
    }

    public void defineMethodStringMatch(StringMatchBoot stringMatch) {
        if (this.methodMatches == null) {
            this.methodMatches = new ArrayList<StringMatchBoot>();
        }
        this.methodMatches.add(stringMatch);
    }

    public boolean isExcludingSpecificMethods() {
        return this.methodMatches != null;
    }

    public boolean isMethodExcluded(String methodName) {
        boolean bReturn = false;
        if (this.methodMatches != null) {
            for (StringMatchBoot nextMethodMatch : this.methodMatches) {
                if (!nextMethodMatch.matchString(methodName)) continue;
                bReturn = true;
                break;
            }
        }
        return bReturn;
    }

    public int hashCode() {
        return HashCodeUtil.calculateHashCode(this.excludeDefinition);
    }

    public String toString() {
        return "Custom Exclude Definition-" + this.excludeDefinition;
    }
}

