/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.InterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ITransformationLimiter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationLimitExceededException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.util.javalang.ADInteger;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTransformationLimiter
implements ITransformationLimiter {
    private final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.tm.DefaultTransformationLimiter");
    private final ConcurrentHashMap<Class<? extends AMethodInterceptor>, ADInteger> mapOfInterceptorsToUse = new ADConcurrentHashMap();
    private static final DefaultTransformationLimiter INSTANCE = new DefaultTransformationLimiter();
    private int maxTransformationPerInterceptor = 500;

    public static DefaultTransformationLimiter getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkApply(String className, ClassLoader classLoader, AClassTransformationRule rule) throws TransformationLimitExceededException {
        ADInteger uses;
        Class<? extends AMethodInterceptor> interceptorClass;
        Class<? extends AMethodInterceptor> clazz = interceptorClass = rule instanceof TransformationRule ? ((TransformationRule)rule).getInterceptor() : null;
        if (interceptorClass != null && (uses = this.mapOfInterceptorsToUse.get(interceptorClass)) != null) {
            this.logger.traceParams("Maximum transformations per interceptor: {}", this.maxTransformationPerInterceptor);
            if (uses.get() >= this.maxTransformationPerInterceptor) {
                String desc = InterceptorClassRegistryBoot.getInterceptorDescription(interceptorClass);
                String transformationExceptionReason = String.format("Max transformations %s reached for interceptor %s when loading class %s", uses, desc, className);
                this.logger.debug(transformationExceptionReason);
                throw new TransformationLimitExceededException(transformationExceptionReason);
            }
        }
    }

    @Override
    public void transformationApplied(String className, AClassTransformationRule rule) {
        Class<? extends AMethodInterceptor> interceptorClass;
        Class<? extends AMethodInterceptor> clazz = interceptorClass = rule instanceof TransformationRule ? ((TransformationRule)rule).getInterceptor() : null;
        if (interceptorClass != null) {
            ADInteger oldUses;
            ADInteger uses = this.mapOfInterceptorsToUse.get(interceptorClass);
            if (uses == null && (oldUses = this.mapOfInterceptorsToUse.putIfAbsent(interceptorClass, uses = new ADInteger(0))) != null) {
                uses = oldUses;
            }
            uses.increment();
        }
    }

    public void setMaxTransformationPerInterceptor(int maxTransformationPerInterceptor) {
        this.maxTransformationPerInterceptor = maxTransformationPerInterceptor;
    }
}

