/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi;

import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ITransformationLimiter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationLimitExceededException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.util.javalang.ADInteger;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TransformationLimiter
implements ITransformationLimiter {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.LimitedTransformationRule");
    private static final String DEFAULT_NUM_QUALIFIERS_PROP_NAME = "appdynamics.bciengine.limit.package.qualifiers";
    private static final long THIRTY_SECONDS = 30000L;
    private static final int DEFAULT_NUM_QUALIFIERS = TransformationLimiter.getDefaultNumQualifiers();
    private int maxTransformations;
    private int maxTransformationsPerPackagePrefix;
    private int numQualifiers;
    private ADConcurrentHashMap<String, ADInteger> mapOfPackagePrefixToTransformCount;
    private ThreadLocal<LastClassTested> tlToLastClassTested = new ThreadLocal();
    private final Set<String> classNamesAppliedTo;

    private static int getDefaultNumQualifiers() {
        return StringOperations.safeParseInteger((String)SystemUtils.getProperty((String)DEFAULT_NUM_QUALIFIERS_PROP_NAME, (String)"2"));
    }

    public TransformationLimiter(int maxTransformations, int maxTransformationsPerPackagePrefix) {
        this(maxTransformations, maxTransformationsPerPackagePrefix, DEFAULT_NUM_QUALIFIERS);
    }

    public TransformationLimiter(int maxTransformations, int maxTransformationsPerPackagePrefix, int numQualifiers) {
        this.maxTransformations = maxTransformations;
        this.maxTransformationsPerPackagePrefix = maxTransformationsPerPackagePrefix;
        this.numQualifiers = numQualifiers;
        if (maxTransformationsPerPackagePrefix > 0) {
            this.mapOfPackagePrefixToTransformCount = new ADConcurrentHashMap();
        }
        this.classNamesAppliedTo = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void checkApply(String className, ClassLoader classLoader, AClassTransformationRule rule) throws TransformationLimitExceededException {
        LastClassTested lastClassTested = this.tlToLastClassTested.get();
        long currentTime = System.currentTimeMillis();
        String reason = null;
        TransformationLimitExceededException exception = null;
        if (lastClassTested != null && lastClassTested.className.equals(className) && currentTime - lastClassTested.timeTested <= 30000L) {
            exception = lastClassTested.exception;
            if (exception != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Found that method checkApply() was already called for class %s for TransformationRule %s - exception %s", className, this, exception));
                }
                throw exception;
            }
        } else {
            String externalClassName = className.replace('/', '.');
            if (!this.classNamesAppliedTo.contains(externalClassName)) {
                if (this.classNamesAppliedTo.size() < this.maxTransformations) {
                    String packagePrefix;
                    ADInteger currentCount;
                    if (this.mapOfPackagePrefixToTransformCount != null && (currentCount = (ADInteger)this.mapOfPackagePrefixToTransformCount.get((Object)(packagePrefix = this.getPackagePrefix(externalClassName)))) != null && currentCount.get() >= this.maxTransformationsPerPackagePrefix) {
                        reason = String.format("Cannot instrument class %s for %s because maximum %d transformations exceeded for package prefix %s", className, this.ruleDescription(rule), this.maxTransformationsPerPackagePrefix, packagePrefix);
                        if (logger.isTraceEnabled()) {
                            logger.trace(reason);
                        }
                    }
                } else {
                    reason = String.format("Cannot instrument class %s for %s because maximum %d transformations exceeded", className, this.ruleDescription(rule), this.maxTransformations);
                    if (logger.isTraceEnabled()) {
                        logger.trace(reason);
                    }
                }
            }
            TransformationLimitExceededException transformationLimitExceededException = exception = reason != null ? new TransformationLimitExceededException(reason) : null;
            if (lastClassTested == null) {
                this.tlToLastClassTested.set(new LastClassTested(className, exception, currentTime));
            } else {
                lastClassTested.className = className;
                lastClassTested.exception = exception;
                lastClassTested.timeTested = currentTime;
            }
            if (exception != null) {
                this.undefineClassNamesAppliedTo(externalClassName);
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("checkApply() will instrument class %s for TransformationRule %s", className, this));
        }
    }

    private String ruleDescription(AClassTransformationRule rule) {
        if (rule instanceof TransformationRule) {
            return "interceptor class " + ((TransformationRule)rule).getInterceptor().getName();
        }
        return rule.getClass().getName();
    }

    private void undefineClassNamesAppliedTo(String className) {
        String packagePrefix;
        ADInteger currentCount;
        if (this.classNamesAppliedTo.remove(className) && this.mapOfPackagePrefixToTransformCount != null && (currentCount = (ADInteger)this.mapOfPackagePrefixToTransformCount.get((Object)(packagePrefix = this.getPackagePrefix(className)))) != null) {
            currentCount.decrementAndGet();
        }
    }

    private String getPackagePrefix(String className) {
        StringBuilder sb = new StringBuilder();
        int numQualifiersSoFar = 0;
        while (numQualifiersSoFar++ < this.numQualifiers && className.length() > 0) {
            int indexOfNextDelim;
            if (sb.length() > 0) {
                sb.append('.');
            }
            if ((indexOfNextDelim = className.indexOf(46)) < 0) {
                sb.append(className);
                break;
            }
            sb.append(className, 0, indexOfNextDelim);
            className = className.substring(indexOfNextDelim + 1);
        }
        return sb.toString();
    }

    public void setMaxTransformations(int maxTransformations) {
        this.maxTransformations = maxTransformations;
    }

    public void setMaxTransformationsPerPackagePrefix(int maxTransformationsPerPackagePrefix) {
        this.maxTransformationsPerPackagePrefix = maxTransformationsPerPackagePrefix;
    }

    @Override
    public void transformationApplied(String className, AClassTransformationRule rule) {
        ADInteger priorCount;
        if (this.classNamesAppliedTo.contains(className = className.replace('/', '.'))) {
            return;
        }
        this.classNamesAppliedTo.add(className);
        if (this.mapOfPackagePrefixToTransformCount == null) {
            return;
        }
        String packagePrefix = this.getPackagePrefix(className);
        ADInteger currentCount = (ADInteger)this.mapOfPackagePrefixToTransformCount.get((Object)packagePrefix);
        if (currentCount == null && (priorCount = (ADInteger)this.mapOfPackagePrefixToTransformCount.putIfAbsent((Object)packagePrefix, (Object)(currentCount = new ADInteger(0)))) != null) {
            currentCount = priorCount;
        }
        currentCount.increment();
    }

    private static class LastClassTested {
        String className;
        TransformationLimitExceededException exception;
        long timeTested;

        LastClassTested(String className, TransformationLimitExceededException result, long timeTested) {
            this.className = className;
            this.exception = result;
            this.timeTested = timeTested;
        }
    }
}

