/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi;

import com.singularity.ee.agent.appagent.kernel.config.acnp.NodeProperty;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodePropertyListener;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.DefaultTransformationLimiter;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.string.StringOperations;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@NodePropertyListener(id="TransformationLimiterConfig")
public class TransformationLimiterConfig {
    private static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.TransformationLimiterConfig");

    @Inject
    public TransformationLimiterConfig(IConfigManager configManager) {
        configManager.registerConfigPropertyChangeListener(this);
        IServiceInfo serviceConfig = configManager.getServiceConfig("BCIEngine");
        String valueFormConfig = serviceConfig.getConfiguration().getConfigProperties().get("max-transformation-per-interceptor");
        DefaultTransformationLimiter.getInstance().setMaxTransformationPerInterceptor(StringOperations.safeParseInteger((String)valueFormConfig, (int)500));
    }

    @NodeProperty(key="max-transformation-per-interceptor", description="max transformation per interceptor", defaultValue="500")
    public void setMaxTransformationPerInterceptor(int maxTransformationPerInterceptor) {
        if (maxTransformationPerInterceptor > 0) {
            logger.info("max-transformation-per-interceptorset to: " + maxTransformationPerInterceptor);
            DefaultTransformationLimiter.getInstance().setMaxTransformationPerInterceptor(maxTransformationPerInterceptor);
        }
    }
}

