/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters;

import com.singularity.ee.agent.util.javalang.ADInteger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentSet;
import com.singularity.ee.util.javaspecific.collections.ADIterator;
import java.util.ArrayList;
import java.util.List;

public class ClassMethodExcludeFilter {
    private volatile ADConcurrentHashMap<String, ADConcurrentSet<MethodTransformationInfo>> classNameVsMethodIdentity;
    public static final String FORWARD_SLASH_STRING = "/";
    public static final String DOT_STRING = ".";
    public static final String DOT_REGEX_STRING = "\\.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ADConcurrentHashMap<String, ADConcurrentSet<MethodTransformationInfo>> getClassNameVsMethodIdentity() {
        if (this.classNameVsMethodIdentity == null) {
            ClassMethodExcludeFilter classMethodExcludeFilter = this;
            synchronized (classMethodExcludeFilter) {
                if (this.classNameVsMethodIdentity == null) {
                    this.classNameVsMethodIdentity = new ADConcurrentHashMap();
                }
            }
        }
        return this.classNameVsMethodIdentity;
    }

    public String[] getExcludedClassNameArray() {
        String[] result = new String[this.getClassNameVsMethodIdentity().size()];
        int index = 0;
        for (String className : this.getClassNameVsMethodIdentity().keySet()) {
            result[index] = ClassMethodExcludeFilter.convertToDotNotation(className);
            ++index;
        }
        return result;
    }

    public static String convertToDotNotation(String toConvert) {
        return toConvert.replaceAll(FORWARD_SLASH_STRING, DOT_STRING);
    }

    public static String convertToSlashNotation(String toConvert) {
        return toConvert.replaceAll(DOT_REGEX_STRING, FORWARD_SLASH_STRING);
    }

    public boolean hasClassMethodExcludeFilter(String className) {
        String[] classNameArray = this.getExcludedClassNameArray();
        if (classNameArray.length > 0) {
            for (String name : classNameArray) {
                if (!name.equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    public List<ADInteger> reset() {
        ArrayList<ADInteger> transformationIds = new ArrayList<ADInteger>();
        ADIterator iterator = this.getClassNameVsMethodIdentity().valuesIterator();
        while (iterator.hasNext()) {
            ADConcurrentSet methodTransformationInfoSet = (ADConcurrentSet)iterator.next();
            ADIterator innerIterator = methodTransformationInfoSet.itemsIterator();
            while (innerIterator.hasNext()) {
                int transformationId = ((MethodTransformationInfo)innerIterator.next()).getTransformationId();
                transformationIds.add(new ADInteger(transformationId));
            }
        }
        this.classNameVsMethodIdentity = null;
        return transformationIds;
    }

    private ADConcurrentSet<MethodTransformationInfo> getExcludedMethodsInfoSet(String className) {
        String internalClassName = ClassMethodExcludeFilter.convertToSlashNotation(className);
        ADConcurrentSet methodSignatures = (ADConcurrentSet)this.getClassNameVsMethodIdentity().get((Object)internalClassName);
        if (methodSignatures == null) {
            ADConcurrentSet toInsert = new ADConcurrentSet();
            methodSignatures = (ADConcurrentSet)this.getClassNameVsMethodIdentity().putIfAbsent((Object)internalClassName, (Object)toInsert);
            if (methodSignatures == null) {
                methodSignatures = toInsert;
            }
        }
        return methodSignatures;
    }

    public void addClassMethodPairToExclude(String className, String methodName, String methodDescriptor, int transformationId) {
        ADConcurrentSet<MethodTransformationInfo> methodSignatures = this.getExcludedMethodsInfoSet(className);
        methodSignatures.add((Object)new MethodTransformationInfo(methodName, methodDescriptor, transformationId));
    }

    public void addClassMethodPairToExclude(String className, String methodName, String methodDescriptor) {
        ADConcurrentSet<MethodTransformationInfo> methodSignatures = this.getExcludedMethodsInfoSet(className);
        methodSignatures.add((Object)new MethodTransformationInfo(methodName, methodDescriptor));
    }

    public boolean removeClassMethodPairToExclude(String className, String methodName, String methodDescriptor) {
        String internalClassName = ClassMethodExcludeFilter.convertToSlashNotation(className);
        ADConcurrentSet methodSignatures = (ADConcurrentSet)this.getClassNameVsMethodIdentity().get((Object)internalClassName);
        if (methodSignatures != null) {
            MethodTransformationInfo methodTransformationInfo = new MethodTransformationInfo(methodName, methodDescriptor);
            return methodSignatures.remove((Object)methodTransformationInfo);
        }
        return false;
    }

    public boolean excludeClassAndMethodCall(String internalClassName, String methodName, String methodDescriptor) {
        ADConcurrentSet methodSignatures = (ADConcurrentSet)this.getClassNameVsMethodIdentity().get((Object)internalClassName);
        if (methodSignatures == null) {
            return false;
        }
        return methodSignatures.contains((Object)new MethodTransformationInfo(methodName, methodDescriptor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassMethodExcludeFilter)) {
            return false;
        }
        ClassMethodExcludeFilter that = (ClassMethodExcludeFilter)o;
        return !(this.classNameVsMethodIdentity != null ? !this.classNameVsMethodIdentity.equals(that.classNameVsMethodIdentity) : that.classNameVsMethodIdentity != null);
    }

    public int hashCode() {
        return this.classNameVsMethodIdentity != null ? this.classNameVsMethodIdentity.hashCode() : 0;
    }

    public static class MethodTransformationInfo {
        private String name;
        private String desc;
        private int transformationId;

        private MethodTransformationInfo() {
        }

        public MethodTransformationInfo(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public MethodTransformationInfo(String name, String desc, int transformationId) {
            this.name = name;
            this.desc = desc;
            this.transformationId = transformationId;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getTransformationId() {
            return this.transformationId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodTransformationInfo)) {
                return false;
            }
            MethodTransformationInfo that = (MethodTransformationInfo)o;
            if (this.desc != null ? !this.desc.equals(that.desc) : that.desc != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
            return result;
        }
    }
}

