/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ABasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ARuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.ANDBasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.ModuleNameMatchClassFilter;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;

public class ClassMethodFilter
implements Cloneable {
    private static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.ClassMethodFilter");
    private ABasicClassFilter basicClassFilter;
    private ARuntimeClassFilter runtimeClassFilter;
    private AByteCodeClassFilter byteCodeClassFilter;
    private AMethodFilter methodFilter;

    public ClassMethodFilter() {
    }

    public ClassMethodFilter(ABasicClassFilter basicClassFilter, ARuntimeClassFilter runtimeClassFilter, AByteCodeClassFilter byteCodeClassFilter, AMethodFilter methodFilter) {
        if (basicClassFilter == null || byteCodeClassFilter == null || runtimeClassFilter == null || methodFilter == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.basicClassFilter = basicClassFilter;
        this.byteCodeClassFilter = byteCodeClassFilter;
        this.runtimeClassFilter = runtimeClassFilter;
        this.methodFilter = methodFilter;
    }

    public void setBasicClassFilter(ABasicClassFilter basicClassFilter) {
        this.basicClassFilter = basicClassFilter;
    }

    public void setRuntimeClassFilter(ARuntimeClassFilter runtimeClassFilter) {
        this.runtimeClassFilter = runtimeClassFilter;
    }

    public void setByteCodeClassFilter(AByteCodeClassFilter byteCodeClassFilter) {
        this.byteCodeClassFilter = byteCodeClassFilter;
    }

    public void setMethodFilter(AMethodFilter methodFilter) {
        this.methodFilter = methodFilter;
    }

    public ABasicClassFilter getBasicClassFilter() {
        return this.basicClassFilter;
    }

    public AByteCodeClassFilter getByteCodeClassFilter() {
        return this.byteCodeClassFilter;
    }

    public ARuntimeClassFilter getRuntimeClassFilter() {
        return this.runtimeClassFilter;
    }

    public AMethodFilter getMethodFilter() {
        return this.methodFilter;
    }

    public void preLoadReferencedClasses() {
        try {
            if (this.basicClassFilter != null) {
                this.basicClassFilter.preLoadReferencedClasses();
            }
            if (this.runtimeClassFilter != null) {
                this.runtimeClassFilter.preLoadReferencedClasses();
            }
            if (this.byteCodeClassFilter != null) {
                this.byteCodeClassFilter.preLoadReferencedClasses();
            }
            if (this.methodFilter != null) {
                this.methodFilter.preLoadReferencedClasses();
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(String.format("%s caught in preLoadReferencedClasses", e), e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassMethodFilter)) {
            return false;
        }
        ClassMethodFilter m = (ClassMethodFilter)o;
        return m.basicClassFilter.equals(this.basicClassFilter) && m.runtimeClassFilter.equals(this.runtimeClassFilter) && m.byteCodeClassFilter.equals(this.byteCodeClassFilter) && m.methodFilter.equals(this.methodFilter);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.basicClassFilter.hashCode();
        result = 37 * result + this.runtimeClassFilter.hashCode();
        result = 37 * result + this.byteCodeClassFilter.hashCode();
        result = 37 * result + this.methodFilter.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.runtimeClassFilter != null) {
            sb.append("Runtime [").append(this.runtimeClassFilter.toString()).append("], ");
        }
        sb.append(" Method [").append(this.methodFilter.toString()).append("] ");
        return sb.toString();
    }

    public void addModuleNameFilter(ModuleNameMatchClassFilter moduleNameMatchClassFilter) {
        ABasicClassFilter originalBasicClassFilter = this.getBasicClassFilter();
        if (originalBasicClassFilter == null) {
            this.setBasicClassFilter(moduleNameMatchClassFilter);
        } else {
            this.setBasicClassFilter(new ANDBasicClassFilter(originalBasicClassFilter, moduleNameMatchClassFilter));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

