/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters;

import com.singularity.ee.agent.appagent.services.bciengine.ASMTypes;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class MethodInfo {
    private int access;
    private boolean staticMethod;
    private String name;
    private String desc;
    private String signature;
    private String[] exceptions;
    private AnnotationInfo[] annotations;
    private Class<?>[] parameterTypes;
    private String toStringValue;

    public MethodInfo(int access, boolean isStatic, String name, String desc, String signature, String[] exceptions, AnnotationInfo[] annotations) {
        this.access = access;
        this.staticMethod = isStatic;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = exceptions;
        this.annotations = annotations;
    }

    public MethodInfo(Constructor constructor) {
        Annotation[] methodAnnotations;
        this.access = constructor.getModifiers();
        this.staticMethod = false;
        this.name = "<init>";
        this.desc = ASMTypes.getInstance().getConstructorDescriptor(constructor);
        this.signature = ASMTypes.getInstance().getConstructorDescriptor(constructor);
        this.parameterTypes = constructor.getParameterTypes();
        Class<?>[] exceptionTypes = constructor.getExceptionTypes();
        this.exceptions = new String[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            this.exceptions[i] = ASMTypes.getInstance().getInternalName(exceptionTypes[i]);
        }
        ArrayList<AnnotationInfo> annotationList = new ArrayList<AnnotationInfo>();
        for (Annotation methodAnnotation : methodAnnotations = constructor.getAnnotations()) {
            annotationList.add(new AnnotationInfo(methodAnnotation));
        }
        this.annotations = annotationList.toArray(new AnnotationInfo[annotationList.size()]);
    }

    public MethodInfo(Method method) {
        Annotation[] methodAnnotations;
        this.access = method.getModifiers();
        this.staticMethod = Modifier.isStatic(method.getModifiers());
        this.name = method.getName();
        this.desc = ASMTypes.getInstance().getMethodDescriptor(method);
        this.signature = ASMTypes.getInstance().getMethodDescriptor(method);
        this.parameterTypes = method.getParameterTypes();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        this.exceptions = new String[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            this.exceptions[i] = ASMTypes.getInstance().getInternalName(exceptionTypes[i]);
        }
        ArrayList<AnnotationInfo> annotationList = new ArrayList<AnnotationInfo>();
        for (Annotation methodAnnotation : methodAnnotations = method.getAnnotations()) {
            annotationList.add(new AnnotationInfo(methodAnnotation));
        }
        this.annotations = annotationList.toArray(new AnnotationInfo[annotationList.size()]);
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getSignature() {
        return this.signature;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public AnnotationInfo[] getAnnotations() {
        return this.annotations;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean isStatic() {
        return this.staticMethod;
    }

    public void setStatic(boolean aStatic) {
        this.staticMethod = aStatic;
    }

    public String toString() {
        if (this.toStringValue == null) {
            StringBuilder sb = new StringBuilder("MethodInfo[");
            sb.append("name=").append(this.name);
            sb.append(",desc=").append(this.desc);
            sb.append(",access=").append(Integer.toString(this.access));
            sb.append("]");
            this.toStringValue = sb.toString();
        }
        return this.toStringValue;
    }
}

