/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters;

import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.asm.spi.filters.RuntimeClassInfoMetaDataHelper;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.IRuntimeClassInfoHelper;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfoClassHelper;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;

public class RuntimeClassInfo {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.RuntimeClassInfo");
    private final boolean classLookAhead;
    private Class<?> runtimeClass;
    private byte[] classBytes;
    private ClassLoader classLoader;
    private String className;
    private IRuntimeClassInfoHelper helper;
    private static final IRuntimeClassInfoHelper DUMMY_CLASS_INFO_HELPER = new IRuntimeClassInfoHelper(){

        @Override
        public boolean isAssignableFrom(String className) {
            return false;
        }

        @Override
        public boolean isAssignableTo(String className) {
            return false;
        }

        @Override
        public boolean hasDirectAnnotation(StringMatchBoot annotationName) {
            return false;
        }

        @Override
        public boolean hasAnnotation(StringMatchBoot annotationName) {
            return false;
        }

        @Override
        public boolean extendsFromClass(StringMatchBoot superClassFilter) {
            return false;
        }

        @Override
        public boolean implementsInterface(StringMatchBoot interfaceName) {
            return false;
        }

        @Override
        public boolean implementsInterface(String interfaceName) {
            return false;
        }

        @Override
        public boolean matchString(StringMatchBoot className) {
            return false;
        }

        @Override
        public String getClassName() {
            return "dummy";
        }

        @Override
        public boolean equalsOrIsAssignableFrom(String name) {
            return false;
        }

        @Override
        public String[] getAllInterfaceNames(String[] initialInterfaceNames) {
            return new String[0];
        }

        @Override
        public boolean isNonClassType() {
            return false;
        }
    };

    public RuntimeClassInfo(Class<?> runtimeClass, boolean classLookAhead, boolean safeToCallHasAnnotation, IClassMetaDataManager metaDataManager) {
        this(runtimeClass, classLookAhead, null, safeToCallHasAnnotation, metaDataManager);
    }

    public RuntimeClassInfo(Class<?> runtimeClass, boolean classLookAhead, byte[] classBytes, boolean safeToCallHasAnnotation, IClassMetaDataManager metaDataManager) {
        this.runtimeClass = runtimeClass;
        this.classLookAhead = classLookAhead;
        this.classBytes = classBytes;
        this.createHelper(safeToCallHasAnnotation, metaDataManager);
    }

    public RuntimeClassInfo(String className, byte[] classBytes, ClassLoader classLoader, IClassMetaDataManager metaDataManager) {
        this.className = className;
        this.classBytes = classBytes;
        this.classLoader = classLoader;
        this.classLookAhead = true;
        this.createHelper(false, metaDataManager);
    }

    private void createHelper(boolean safeToCallHasAnnotation, IClassMetaDataManager metaDataManager) {
        if (this.runtimeClass != null || !this.classLookAhead) {
            this.helper = new RuntimeClassInfoClassHelper(this.runtimeClass, safeToCallHasAnnotation);
        } else {
            IClassMetaData classMetaData = this.runtimeClass != null ? metaDataManager.getClassMetaData(this.runtimeClass, this.classBytes) : metaDataManager.getClassMetaData(this.className, this.classBytes, this.classLoader);
            IRuntimeClassInfoHelper iRuntimeClassInfoHelper = this.helper = classMetaData != null ? new RuntimeClassInfoMetaDataHelper(classMetaData, metaDataManager) : null;
            if (this.helper == null) {
                String className = this.className != null ? this.className : this.runtimeClass.getName();
                logger.warn(String.format("IRuntimeClassInfoHelper cannot be created for RuntimeClassInfo for class %s", className));
                this.helper = DUMMY_CLASS_INFO_HELPER;
            }
        }
    }

    public IRuntimeClassInfoHelper getHelper() {
        return this.helper;
    }

    public Class<?> getRunTimeClass() {
        return this.runtimeClass;
    }
}

