/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters;

import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.IRuntimeClassInfoHelper;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ClassLoaderUtil;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;

class RuntimeClassInfoClassHelper
implements IRuntimeClassInfoHelper {
    private final Class<?> clazz;
    private final boolean safeToCallHasAnnotation;

    RuntimeClassInfoClassHelper(Class<?> clazz, boolean safeToCallHasAnnotation) {
        this.clazz = clazz;
        this.safeToCallHasAnnotation = safeToCallHasAnnotation;
    }

    @Override
    public boolean isAssignableFrom(String className) {
        Class subClassOrInterface;
        if (this.clazz == null) {
            return false;
        }
        try {
            String name = ClassNameUtils.convertClassNameToExternalFormat(className);
            subClassOrInterface = ClassLoaderUtil.loadClass(this.clazz, name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return this.clazz.isAssignableFrom(subClassOrInterface);
    }

    @Override
    public boolean isAssignableTo(String className) {
        Class subClassOrInterface;
        if (this.clazz == null) {
            return false;
        }
        try {
            String name = ClassNameUtils.convertClassNameToExternalFormat(className);
            subClassOrInterface = ClassLoaderUtil.loadClass(this.clazz, name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return subClassOrInterface.isAssignableFrom(this.clazz);
    }

    @Override
    public boolean hasDirectAnnotation(StringMatchBoot annotationName) {
        if (this.safeToCallHasAnnotation) {
            return AgentReflectionUtility.hasDirectAnnotation(this.clazz, annotationName);
        }
        return false;
    }

    @Override
    public boolean hasAnnotation(StringMatchBoot annotationName) {
        if (this.safeToCallHasAnnotation) {
            return AgentReflectionUtility.hasAnnotation(this.clazz, annotationName);
        }
        return false;
    }

    @Override
    public boolean extendsFromClass(StringMatchBoot superClassFilter) {
        return AgentReflectionUtility.extendsFromClass(this.clazz, superClassFilter);
    }

    @Override
    public boolean implementsInterface(StringMatchBoot interfaceName) {
        return AgentReflectionUtility.implementsInterface(this.clazz, interfaceName);
    }

    @Override
    public boolean implementsInterface(String interfaceName) {
        return AgentReflectionUtility.implementsInterface(this.clazz, interfaceName);
    }

    @Override
    public boolean matchString(StringMatchBoot className) {
        if (this.clazz != null) {
            return className.matchString(this.clazz.getName());
        }
        return false;
    }

    @Override
    public String getClassName() {
        return this.clazz != null ? this.clazz.getName() : null;
    }

    @Override
    public boolean equalsOrIsAssignableFrom(String name) {
        return AgentReflectionUtility.equalsOrIsAssignableFrom(this.clazz, name);
    }

    @Override
    public String[] getAllInterfaceNames(String[] initialInterfaceNames) {
        return AgentReflectionUtility.getInterfacesForClass(this.clazz);
    }

    @Override
    public boolean isNonClassType() {
        return this.clazz.isAnnotation() || this.clazz.isEnum() || this.clazz.isInterface();
    }
}

