/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ABasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InSpecifiedPackagesFilter
extends ABasicClassFilter {
    private static final String DEFAULT_PACKAGE = "";
    private Set<String> packageNames;

    public InSpecifiedPackagesFilter(String[] packages) {
        if (packages == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.packageNames = new HashSet<String>();
        for (int i = 0; i < packages.length; ++i) {
            this.packageNames.add(packages[i].trim());
        }
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo) {
        String className = basicClassInfo.getClassName();
        int classNameIndex = className.lastIndexOf(47);
        String packageName = classNameIndex == -1 ? DEFAULT_PACKAGE : className.substring(0, classNameIndex);
        for (String refPackage : this.packageNames) {
            if (!packageName.startsWith(refPackage) || packageName.length() != refPackage.length() && (packageName.length() <= refPackage.length() || packageName.charAt(refPackage.length()) != '/')) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof InSpecifiedPackagesFilter)) {
            return false;
        }
        InSpecifiedPackagesFilter m = (InSpecifiedPackagesFilter)o;
        if (m.packageNames.size() != this.packageNames.size()) {
            return false;
        }
        Iterator<String> ite = m.packageNames.iterator();
        while (ite.hasNext()) {
            if (this.packageNames.contains(ite.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 17;
        Iterator<String> ite = this.packageNames.iterator();
        while (ite.hasNext()) {
            result = 37 * result + ite.next().hashCode();
        }
        return result;
    }
}

