/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters;

import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ABasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;

public class ModuleNameMatchClassFilter
extends ABasicClassFilter {
    private final StringMatchBoot match;
    private final IJava9Util java9Util;

    public ModuleNameMatchClassFilter(StringMatchBoot match, IJava9Util java9Util) {
        this.match = match;
        this.java9Util = java9Util;
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo) {
        Object module = basicClassInfo.getModule();
        if (module == null) {
            return false;
        }
        if (this.java9Util != null) {
            String moduleName = this.java9Util.getModuleName(module);
            return this.match.matchString(moduleName);
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.match.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean bReturn = false;
        if (obj instanceof ModuleNameMatchClassFilter) {
            ModuleNameMatchClassFilter other = (ModuleNameMatchClassFilter)obj;
            bReturn = this.hashCode() == other.hashCode() && this.match.equals((Object)other.match);
        }
        return bReturn;
    }

    public String toString() {
        return "[ModuleNameMatchClassFilter: match=" + this.match + "]";
    }
}

