/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ABasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MultipleSpecifiedClassesFilter
extends ABasicClassFilter {
    private Set<String> classNames;

    public MultipleSpecifiedClassesFilter(String[] classes) {
        if (classes == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.classNames = new HashSet<String>();
        for (int i = 0; i < classes.length; ++i) {
            this.classNames.add(classes[i]);
        }
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo) {
        return this.classNames.contains(basicClassInfo.getClassName());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof MultipleSpecifiedClassesFilter)) {
            return false;
        }
        MultipleSpecifiedClassesFilter m = (MultipleSpecifiedClassesFilter)o;
        if (m.classNames.size() != this.classNames.size()) {
            return false;
        }
        Iterator<String> ite = m.classNames.iterator();
        while (ite.hasNext()) {
            if (this.classNames.contains(ite.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 17;
        Iterator<String> ite = this.classNames.iterator();
        while (ite.hasNext()) {
            result = 37 * result + ite.next().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultipleSpecifiedClassesFilter");
        sb.append("{classNames=").append(this.classNames);
        sb.append('}');
        return sb.toString();
    }
}

