/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters;

import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;

public class CustomImmediateSubclassOfSpecifiedClassFilter
extends AByteCodeClassFilter {
    private final StringMatchBoot superClassNameMatch;

    public CustomImmediateSubclassOfSpecifiedClassFilter(StringMatchBoot superClassNameMatcher) {
        this.superClassNameMatch = superClassNameMatcher;
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo) {
        String superClassName = byteCodeClassInfo.getSuperClassName();
        return this.superClassNameMatch.matchString(ClassNameUtils.convertClassNameToExternalFormat(superClassName)) || this.superClassNameMatch.matchString(ClassNameUtils.convertClassNameToInternalFormat(superClassName));
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CustomImmediateSubclassOfSpecifiedClassFilter)) {
            return false;
        }
        CustomImmediateSubclassOfSpecifiedClassFilter m = (CustomImmediateSubclassOfSpecifiedClassFilter)o;
        return m.superClassNameMatch.equals((Object)this.superClassNameMatch);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + this.superClassNameMatch.hashCode();
        return result;
    }

    public String toString() {
        return "super class=" + this.superClassNameMatch;
    }
}

