/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters;

import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;

public class CustomSpecifiedInterfaceFilter
extends AByteCodeClassFilter {
    private final StringMatchBoot interfaceMatch;

    public CustomSpecifiedInterfaceFilter(StringMatchBoot interfaceMatcher) {
        this.interfaceMatch = interfaceMatcher;
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo) {
        if (byteCodeClassInfo.getInterfaceNames() != null) {
            for (int i = 0; i < byteCodeClassInfo.getInterfaceNames().length; ++i) {
                String nextInterfaceName = byteCodeClassInfo.getInterfaceNames()[i];
                if (!this.interfaceMatch.matchString(ClassNameUtils.convertClassNameToExternalFormat(nextInterfaceName)) && !this.interfaceMatch.matchString(ClassNameUtils.convertClassNameToInternalFormat(nextInterfaceName))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CustomSpecifiedInterfaceFilter)) {
            return false;
        }
        CustomSpecifiedInterfaceFilter m = (CustomSpecifiedInterfaceFilter)o;
        return m.interfaceMatch.equals((Object)this.interfaceMatch);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + this.interfaceMatch.hashCode();
        return result;
    }

    public String toString() {
        return "interface=" + this.interfaceMatch;
    }
}

