/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters;

import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;

public class ImmediateSubclassOfSpecifiedClassFilter
extends AByteCodeClassFilter {
    private final String superClassName;

    public ImmediateSubclassOfSpecifiedClassFilter(String superClassName) {
        if (superClassName == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.superClassName = superClassName;
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo) {
        String superClassName = byteCodeClassInfo.getSuperClassName();
        return this.superClassName.equals(ClassNameUtils.convertClassNameToExternalFormat(superClassName)) || this.superClassName.equals(ClassNameUtils.convertClassNameToInternalFormat(superClassName));
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ImmediateSubclassOfSpecifiedClassFilter)) {
            return false;
        }
        ImmediateSubclassOfSpecifiedClassFilter m = (ImmediateSubclassOfSpecifiedClassFilter)o;
        return m.superClassName.equals(this.superClassName);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + this.superClassName.hashCode();
        return result;
    }

    public String toString() {
        return "super class=" + this.superClassName;
    }
}

