/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters;

import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;

public class ImplementsSpecifiedInterfaceFilter
extends AByteCodeClassFilter {
    private final String interfaceName;

    public ImplementsSpecifiedInterfaceFilter(String interfaceName) {
        if (interfaceName == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.interfaceName = interfaceName;
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo) {
        if (byteCodeClassInfo.getInterfaceNames() != null) {
            for (int i = 0; i < byteCodeClassInfo.getInterfaceNames().length; ++i) {
                String nextInterfaceName = byteCodeClassInfo.getInterfaceNames()[i];
                if (!this.interfaceName.equals(ClassNameUtils.convertClassNameToExternalFormat(nextInterfaceName)) && !this.interfaceName.equals(ClassNameUtils.convertClassNameToInternalFormat(nextInterfaceName))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ImplementsSpecifiedInterfaceFilter)) {
            return false;
        }
        ImplementsSpecifiedInterfaceFilter m = (ImplementsSpecifiedInterfaceFilter)o;
        return m.interfaceName.equals(this.interfaceName);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + this.interfaceName.hashCode();
        return result;
    }

    public String toString() {
        return "interface=" + this.interfaceName;
    }
}

