/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;

public class CustomMethodNameMatchFilter
extends AMethodFilter {
    private static final String METHOD_DESC_WITH_EMPTY_PARAMS = "()";
    private StringMatchBoot methodNameMatcher;
    private boolean matchWithNoParamsOnly;

    public CustomMethodNameMatchFilter(StringMatchBoot methodName) {
        this.methodNameMatcher = methodName;
    }

    public CustomMethodNameMatchFilter(StringMatchBoot methodNameMatcher, boolean matchWithNoParamsOnly) {
        this.methodNameMatcher = methodNameMatcher;
        this.matchWithNoParamsOnly = matchWithNoParamsOnly;
    }

    @Override
    public boolean matchMethod(MethodInfo methodInfo) {
        if (this.matchWithNoParamsOnly && this.methodNameMatcher.matchString(methodInfo.getName())) {
            return methodInfo.getDesc().startsWith(METHOD_DESC_WITH_EMPTY_PARAMS);
        }
        return this.methodNameMatcher.matchString(methodInfo.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CustomMethodNameMatchFilter)) {
            return false;
        }
        CustomMethodNameMatchFilter m = (CustomMethodNameMatchFilter)o;
        return m.methodNameMatcher.equals((Object)this.methodNameMatcher);
    }

    @Override
    public int hashCode() {
        return this.methodNameMatcher.hashCode();
    }

    public String toString() {
        return " method=" + this.methodNameMatcher;
    }
}

