/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.DefaultMappings;

public class HasSpecifiedAnnotationMethodFilter
extends AMethodFilter {
    public static final String ANNOTATION_PREFIX = "@";
    private String annotationName;

    public HasSpecifiedAnnotationMethodFilter(String annotationName) {
        if (annotationName == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.annotationName = DefaultMappings.convertToTypeDescriptor(annotationName);
    }

    @Override
    public boolean matchMethod(MethodInfo methodInfo) {
        if (methodInfo.getAnnotations() != null) {
            for (int i = 0; i < methodInfo.getAnnotations().length; ++i) {
                if (!this.annotationName.equals(methodInfo.getAnnotations()[i].getDesc())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof HasSpecifiedAnnotationMethodFilter)) {
            return false;
        }
        HasSpecifiedAnnotationMethodFilter m = (HasSpecifiedAnnotationMethodFilter)o;
        return m.annotationName.equals(this.annotationName);
    }

    @Override
    public int hashCode() {
        return this.annotationName.hashCode();
    }

    public static boolean isAnnotationMatch(String className) {
        return className.startsWith(ANNOTATION_PREFIX);
    }

    public static String getAnnotationClassName(String className) {
        return className.substring(className.indexOf(ANNOTATION_PREFIX) + 1, className.length());
    }
}

