/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters;

import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.EqualsUtil;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import java.util.Arrays;

public class MethodNameAndArgsMatchFilter
extends AMethodFilter {
    private final StringMatchBoot classMatch;
    private final String[] argTypes;
    private volatile Integer hashValue;
    private String toStringValue;

    public MethodNameAndArgsMatchFilter(StringMatchBoot classMatch, String[] argTypes) {
        this.classMatch = classMatch;
        this.argTypes = argTypes;
    }

    @Override
    public boolean matchMethod(MethodInfo methodInfo) {
        boolean bReturn = false;
        if (this.classMatch.matchString(methodInfo.getName())) {
            if (this.argTypes != null) {
                Type[] argTypes = Type.getArgumentTypes((String)methodInfo.getDesc());
                if (argTypes.length == this.argTypes.length) {
                    bReturn = true;
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (argTypes[i].getClassName().equals(this.argTypes[i])) continue;
                        bReturn = false;
                        break;
                    }
                }
            } else {
                bReturn = true;
            }
        }
        return bReturn;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == null) {
            int iHashValue = this.classMatch.hashCode();
            iHashValue = 31 * iHashValue + (this.argTypes != null ? ArrayUtils.getHashCode(this.argTypes) : 0);
            this.hashValue = iHashValue;
        }
        return this.hashValue;
    }

    @Override
    public boolean equals(Object obj) {
        boolean bReturn;
        boolean bl = bReturn = this == obj;
        if (!bReturn && obj instanceof MethodNameAndArgsMatchFilter) {
            MethodNameAndArgsMatchFilter other = (MethodNameAndArgsMatchFilter)obj;
            bReturn = this.hashCode() == other.hashCode() && this.classMatch.equals((Object)other.classMatch) && EqualsUtil.safeCompareArrays(this.argTypes, other.argTypes);
        }
        return bReturn;
    }

    public String toString() {
        if (this.toStringValue == null) {
            this.toStringValue = String.format("MethodNameAndArgsMatchFilter:<matchType:<%s> args:<%s>>", this.classMatch.toString(), this.argTypes != null ? Arrays.toString(this.argTypes) : "null");
        }
        return this.toStringValue;
    }
}

