/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters;

import com.singularity.ee.agent.appagent.services.bciengine.ASMTypes;
import com.singularity.ee.agent.appagent.services.bciengine.IASMType;
import com.singularity.ee.util.string.StringOperations;

public class MethodSignature {
    private String methodName;
    private String methodDesc;

    public MethodSignature(String methodName, String methodReturnType, String[] methodParamTypes) {
        if (methodName == null || methodReturnType == null || methodParamTypes == null) {
            String message = String.format("Non-NULL arguments required. [methodName,methodReturnType,methodParamTypes]=[%s,%s,%s]", methodName, methodReturnType, StringOperations.toStrArray((String[])methodParamTypes));
            throw new IllegalArgumentException(message);
        }
        this.methodName = methodName;
        IASMType returnType = ASMTypes.getInstance().getType(methodReturnType);
        IASMType[] paramTypes = new IASMType[methodParamTypes.length];
        for (int i = 0; i < methodParamTypes.length; ++i) {
            paramTypes[i] = ASMTypes.getInstance().getType(methodParamTypes[i]);
        }
        this.methodDesc = this.getMethodDescriptorWithoutReturnType(ASMTypes.getInstance().getMethodDescriptor(returnType, paramTypes));
    }

    public MethodSignature(String methodName, String methodDesc) {
        if (methodName == null || methodDesc == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.methodName = methodName;
        this.methodDesc = this.getMethodDescriptorWithoutReturnType(methodDesc);
    }

    private String getMethodDescriptorWithoutReturnType(String methodDescriptor) {
        return methodDescriptor.substring(0, methodDescriptor.indexOf(41) + 1);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature m = (MethodSignature)o;
        return m.methodName.equals(this.methodName) && m.methodDesc.equals(this.methodDesc);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.methodName.hashCode();
        result = 37 * result + this.methodDesc.hashCode();
        return result;
    }

    public String toString() {
        return "Method Name -" + this.methodName + " Method Desc -" + this.methodDesc;
    }
}

