/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.MethodSignature;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.Iterator;
import java.util.Set;

public class MultipleSpecifiedMethodsFilter
extends AMethodFilter {
    private Set<MethodSignature> methodSignatures;

    public MultipleSpecifiedMethodsFilter(MethodSignature[] methodSignatures) {
        if (methodSignatures == null) {
            throw new IllegalArgumentException("Non-NULL arguments required.");
        }
        this.methodSignatures = CollectionHelper.createHashSet(methodSignatures);
    }

    @Override
    public boolean matchMethod(MethodInfo methodInfo) {
        return this.methodSignatures.contains(new MethodSignature(methodInfo.getName(), methodInfo.getDesc()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof MultipleSpecifiedMethodsFilter)) {
            return false;
        }
        MultipleSpecifiedMethodsFilter m = (MultipleSpecifiedMethodsFilter)o;
        Iterator<MethodSignature> ite = m.methodSignatures.iterator();
        while (ite.hasNext()) {
            if (this.methodSignatures.contains(ite.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 17;
        Iterator<MethodSignature> ite = this.methodSignatures.iterator();
        while (ite.hasNext()) {
            result = 37 * result + ite.next().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultipleSpecifiedMethodsFilter");
        sb.append("{methodSignatures=").append(this.methodSignatures);
        sb.append('}');
        return sb.toString();
    }
}

