/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.DefaultMappingsHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultMappings {
    static Map<String, String> defaultMappings = new HashMap<String, String>();
    public static final String ARRAY = "[]";
    public static final String TYPE_DESCRIPTOR_PREFIX = "L";
    public static final String TYPE_DESCRIPTOR_TERMINATOR = ";";
    public static final String ARRAY_TYPE_PREFIX = "[";

    public static String getTypeDescriptor(String className) {
        if (defaultMappings.get(className) != null) {
            return defaultMappings.get(className);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TYPE_DESCRIPTOR_PREFIX);
        sb.append(className.replace(".", "/"));
        sb.append(TYPE_DESCRIPTOR_TERMINATOR);
        return sb.toString();
    }

    public static String convertToTypeDescriptor(String classStr) {
        if (DefaultMappings.isArray(classStr)) {
            return DefaultMappings.convertArrayDescription(classStr);
        }
        return DefaultMappings.getTypeDescriptor(classStr);
    }

    public static String convertArrayDescription(String arrayStr) {
        StringBuffer sb = new StringBuffer();
        String arrPart = arrayStr.substring(arrayStr.indexOf(ARRAY_TYPE_PREFIX), arrayStr.length());
        String classPart = arrayStr.substring(0, arrayStr.indexOf(ARRAY_TYPE_PREFIX));
        DefaultMappingsHelper.appendTokens(sb, arrPart, ARRAY_TYPE_PREFIX);
        sb.append(DefaultMappings.getTypeDescriptor(classPart));
        return sb.toString();
    }

    public static boolean isArray(String className) {
        return className.indexOf(ARRAY_TYPE_PREFIX) > 0;
    }

    public static String[] convertParamArrayToDescriptorArray(List<String> paramList) {
        String[] paramArray = new String[paramList.size()];
        for (int i = 0; i < paramList.size(); ++i) {
            paramArray[i] = DefaultMappings.convertToTypeDescriptor(paramList.get(i));
        }
        return paramArray;
    }

    public static void main(String[] args) {
        String arr = "java.lang.String[][][]";
    }

    static {
        defaultMappings.put("boolean", "Z");
        defaultMappings.put("char", "C");
        defaultMappings.put("byte", "B");
        defaultMappings.put("short", "S");
        defaultMappings.put("int", "I");
        defaultMappings.put("float", "F");
        defaultMappings.put("long", "J");
        defaultMappings.put("double", "D");
        defaultMappings.put("void", "V");
    }
}

