/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ARuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.CustomMatchClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.SingleSpecifiedClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.ALLByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.ALLMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.CustomMethodNameMatchFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.MethodNameListMatchFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.ALLRuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.SingleSpecifiedRuntimeFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.DefaultMappingsHelper;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodFilterGenerator;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodInfo;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import java.util.List;
import java.util.Set;

public class MatchClassNameFilter
extends ClassMethodFilter {
    private static final ARuntimeClassFilter runtimeClassFilter = new ALLRuntimeClassFilter();
    private static final AByteCodeClassFilter byteCodeFilter = new ALLByteCodeClassFilter();
    private StringMatchBoot classMatch;

    public MatchClassNameFilter(String className) {
        this.classMatch = new StringMatchBoot(StringMatchBootType.EQUALS, className);
        this.setRuntimeClassFilter(new SingleSpecifiedRuntimeFilter(this.classMatch));
        this.setByteCodeClassFilter(byteCodeFilter);
        this.setBasicClassFilter(new SingleSpecifiedClassFilter(className.replace(".", "/")));
        this.setMethodFilter(new ALLMethodFilter());
    }

    public MatchClassNameFilter(String clsName, String[] methodNames) {
        this(clsName);
        Set<String> methSet = CollectionHelper.createHashSet(methodNames);
        this.setMethodFilter(new MethodNameListMatchFilter(methSet));
    }

    public MatchClassNameFilter(String className, StringMatchBoot methodNameMatcher) {
        this(className);
        this.setMethodFilter(new CustomMethodNameMatchFilter(methodNameMatcher));
    }

    public MatchClassNameFilter(String className, StringMatchBoot methodNameMatcher, boolean matchWithNoArgsOnly) {
        this(className);
        this.setMethodFilter(new CustomMethodNameMatchFilter(methodNameMatcher, matchWithNoArgsOnly));
    }

    public MatchClassNameFilter(String className, AMethodFilter methodFilter) {
        this(className);
        this.setMethodFilter(methodFilter);
    }

    public MatchClassNameFilter(String className, List<MethodInfo> methodInfo) {
        this(className);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchClassNameFilter(String className, MethodInfo methodInfo) {
        this(className);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchClassNameFilter(StringMatchBoot classNameData) {
        this.classMatch = classNameData;
        this.setRuntimeClassFilter(new SingleSpecifiedRuntimeFilter(classNameData));
        this.setByteCodeClassFilter(byteCodeFilter);
        StringMatchBoot matcher = classNameData.deepCopy();
        if (classNameData.getMatchType() != StringMatchBootType.REGEX) {
            matcher = new StringMatchBoot(classNameData.getMatchType(), classNameData.getMatchPattern().replace(".", "/"));
        }
        this.setBasicClassFilter(new CustomMatchClassFilter(matcher));
        this.setMethodFilter(new ALLMethodFilter());
    }

    public MatchClassNameFilter(StringMatchBoot classNameData, StringMatchBoot methodNameMatcher) {
        this(classNameData);
        this.setMethodFilter(DefaultMappingsHelper.getMethodFilter(methodNameMatcher));
    }

    public MatchClassNameFilter(StringMatchBoot classNameData, List<MethodInfo> methodInfo) {
        this(classNameData);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchClassNameFilter(StringMatchBoot classNameData, MethodInfo methodInfo) {
        this(classNameData);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchClassNameFilter(StringMatchBoot classMatch, Set<String> methodNames) {
        this(classMatch);
        this.setMethodFilter(new MethodNameListMatchFilter(methodNames));
    }

    public StringMatchBoot getClassMatch() {
        return this.classMatch;
    }
}

