/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ABasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.ALLBasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.CustomSpecifiedInterfaceFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.ImplementsSpecifiedInterfaceFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.ALLMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.CustomMethodNameMatchFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.MethodNameListMatchFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.ImplementsInterfaceDirectlyRuntimeFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.DefaultMappingsHelper;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodFilterGenerator;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodInfo;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import java.util.List;
import java.util.Set;

public class MatchInterfaceFilter
extends ClassMethodFilter {
    private static final ABasicClassFilter basicClassFilter = new ALLBasicClassFilter();

    public MatchInterfaceFilter(String interfaceName) {
        this.setRuntimeClassFilter(new ImplementsInterfaceDirectlyRuntimeFilter(new StringMatchBoot(StringMatchBootType.EQUALS, interfaceName)));
        this.setByteCodeClassFilter(new ImplementsSpecifiedInterfaceFilter(interfaceName.replace(".", "/")));
        this.setBasicClassFilter(basicClassFilter);
        this.setMethodFilter(new ALLMethodFilter());
    }

    public MatchInterfaceFilter(String interfaceName, AMethodFilter methodFilter) {
        this(interfaceName);
        this.setMethodFilter(methodFilter);
    }

    public MatchInterfaceFilter(String interfaceName, ABasicClassFilter clsNameFilter, AMethodFilter methodFilter) {
        this(interfaceName);
        this.setMethodFilter(methodFilter);
        this.setBasicClassFilter(clsNameFilter);
    }

    public MatchInterfaceFilter(String interfaceName, StringMatchBoot methodNameMatcher) {
        this(interfaceName);
        this.setMethodFilter(new CustomMethodNameMatchFilter(methodNameMatcher));
    }

    public MatchInterfaceFilter(String interfaceName, StringMatchBoot methodNameMatcher, boolean matchNoArgsOnly) {
        this(interfaceName);
        this.setMethodFilter(new CustomMethodNameMatchFilter(methodNameMatcher, matchNoArgsOnly));
    }

    public MatchInterfaceFilter(String interfaceName, ABasicClassFilter clsNameFilter, StringMatchBoot methodNameMatcher) {
        this(interfaceName, methodNameMatcher);
        this.setBasicClassFilter(clsNameFilter);
    }

    public MatchInterfaceFilter(String interfaceName, ABasicClassFilter clsNameFilter, MethodInfo methodInfo) {
        this(interfaceName);
        this.setBasicClassFilter(clsNameFilter);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchInterfaceFilter(String interfaceName, MethodInfo methodInfo) {
        this(interfaceName);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchInterfaceFilter(String interfaceName, String[] methodNames) {
        this(interfaceName);
        Set<String> methSet = CollectionHelper.createHashSet(methodNames);
        this.setMethodFilter(new MethodNameListMatchFilter(methSet));
    }

    public MatchInterfaceFilter(String interfaceName, List<MethodInfo> methodInfo) {
        this(interfaceName);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchInterfaceFilter(StringMatchBoot interfaceData) {
        this.setRuntimeClassFilter(new ImplementsInterfaceDirectlyRuntimeFilter(interfaceData));
        StringMatchBoot matcher = new StringMatchBoot(interfaceData.getMatchType(), interfaceData.getMatchPattern().replace(".", "/"));
        this.setByteCodeClassFilter(new CustomSpecifiedInterfaceFilter(matcher));
        this.setBasicClassFilter(basicClassFilter);
        this.setMethodFilter(new ALLMethodFilter());
    }

    public MatchInterfaceFilter(StringMatchBoot interfaceData, StringMatchBoot methodNameMatcher) {
        this(interfaceData);
        this.setMethodFilter(DefaultMappingsHelper.getMethodFilter(methodNameMatcher));
    }

    public MatchInterfaceFilter(StringMatchBoot interfaceData, MethodInfo methodInfo) {
        this(interfaceData);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchInterfaceFilter(StringMatchBoot interfaceData, List<MethodInfo> methodInfo) {
        this(interfaceData);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }
}

