/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ABasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ARuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.ALLBasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.CustomImmediateSubclassOfSpecifiedClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.ImmediateSubclassOfSpecifiedClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.ALLMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.CustomMethodNameMatchFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.methodfilters.MethodNameListMatchFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.ALLRuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.ImmediateSubClassRuntimeFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.DefaultMappingsHelper;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodFilterGenerator;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodInfo;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import java.util.List;
import java.util.Set;

public class MatchSuperClassNameFilter
extends ClassMethodFilter {
    private static final ARuntimeClassFilter runtimeClassFilter = new ALLRuntimeClassFilter();
    private static final ABasicClassFilter basicClassFilter = new ALLBasicClassFilter();

    public MatchSuperClassNameFilter(String superClassName) {
        this.setRuntimeClassFilter(new ImmediateSubClassRuntimeFilter(new StringMatchBoot(StringMatchBootType.EQUALS, superClassName)));
        this.setByteCodeClassFilter(new ImmediateSubclassOfSpecifiedClassFilter(superClassName.replace(".", "/")));
        this.setBasicClassFilter(basicClassFilter);
        this.setMethodFilter(new ALLMethodFilter());
    }

    public MatchSuperClassNameFilter(String superClassName, ABasicClassFilter basicClassFilter) {
        this(superClassName);
        this.setBasicClassFilter(basicClassFilter);
    }

    public MatchSuperClassNameFilter(String superClassName, StringMatchBoot methodNameMatcher) {
        this(superClassName);
        this.setMethodFilter(new CustomMethodNameMatchFilter(methodNameMatcher));
    }

    public MatchSuperClassNameFilter(String superClassName, StringMatchBoot methodNameMatcher, boolean matchNoArgsOnly) {
        this(superClassName);
        this.setMethodFilter(new CustomMethodNameMatchFilter(methodNameMatcher, matchNoArgsOnly));
    }

    public MatchSuperClassNameFilter(String superClassName, MethodInfo methodInfo) {
        this(superClassName);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchSuperClassNameFilter(String superClassName, List<MethodInfo> methodInfo) {
        this(superClassName);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchSuperClassNameFilter(String superClassName, AMethodFilter methodFilter) {
        this(superClassName);
        this.setMethodFilter(methodFilter);
    }

    public MatchSuperClassNameFilter(String superClassName, String packagePrefix, MethodInfo methodInfo) {
        this(superClassName, new StringMatchBoot(StringMatchBootType.STARTSWITH, packagePrefix));
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchSuperClassNameFilter(StringMatchBoot superClassNameData) {
        this.setRuntimeClassFilter(new ImmediateSubClassRuntimeFilter(superClassNameData));
        StringMatchBoot matcher = new StringMatchBoot(superClassNameData.getMatchType(), superClassNameData.getMatchPattern().replace(".", "/"));
        this.setByteCodeClassFilter(new CustomImmediateSubclassOfSpecifiedClassFilter(matcher));
        this.setBasicClassFilter(basicClassFilter);
        this.setMethodFilter(new ALLMethodFilter());
    }

    public MatchSuperClassNameFilter(StringMatchBoot superClassNameData, StringMatchBoot methodNameData) {
        this(superClassNameData);
        this.setMethodFilter(DefaultMappingsHelper.getMethodFilter(methodNameData));
    }

    public MatchSuperClassNameFilter(StringMatchBoot superClassNameData, MethodInfo methodInfo) {
        this(superClassNameData);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchSuperClassNameFilter(StringMatchBoot superClassNameData, List<MethodInfo> methodInfo) {
        this(superClassNameData);
        this.setMethodFilter(MethodFilterGenerator.convert(methodInfo));
    }

    public MatchSuperClassNameFilter(String superClassName, String[] methodNames) {
        this(superClassName);
        Set<String> methSet = CollectionHelper.createHashSet(methodNames);
        this.setMethodFilter(new MethodNameListMatchFilter(methSet));
    }
}

