/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.transformation;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.IAnonymousClassDefTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.security.AccessControlException;
import java.security.ProtectionDomain;

public class AnonymousClassDefTransformer
implements IAnonymousClassDefTransformer {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.AnonymousClassDefTransformer");
    private final IByteCodeTransformer delegate;

    public AnonymousClassDefTransformer(IByteCodeTransformer classTransformerToDelegateTo) {
        this.delegate = classTransformerToDelegateTo;
    }

    public byte[] classDefTrap(Class<?> hostClass, byte[] data, Object[] cpPatches) {
        if (hostClass == null || data == null) {
            return data;
        }
        logger.traceParams("Anonymous class definition, hostClass = {}, #bytes = {}, CP patches is {}", hostClass.getName(), data.length, cpPatches == null ? "NULL" : "NON-null");
        if (cpPatches != null) {
            return data;
        }
        try {
            ClassLoader loader = hostClass.getClassLoader();
            ProtectionDomain protectionDomain = hostClass.getProtectionDomain();
            String className = null;
            Class<?> classBeingRedefined = null;
            byte[] newBytes = this.delegate.transform(loader, className, classBeingRedefined, protectionDomain, data);
            if (newBytes != null) {
                logger.traceParams("Redefined anonymous class, new bytecode length = {}", newBytes.length);
            }
            return newBytes == null ? data : newBytes;
        }
        catch (AccessControlException ac) {
            logger.warn("Security Exception while instrumenting anonymous class " + hostClass.getName());
            return data;
        }
        catch (Exception e) {
            logger.warn("Exception while instrumenting anonymous class " + hostClass.getName(), e);
            return data;
        }
    }
}

